package org.myoggradio.buforth;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Environment;
import android.os.Looper;
import android.widget.Toast;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class RestoreTerminThread extends Thread
{
    private ArrayList<SatzTermin> termine = new ArrayList<SatzTermin>();
    private Context context = null;
    private Uri name = null;
    public RestoreTerminThread(Context context, Uri name)

    {
        this.context = context;
        this.name = name;
    }
    @Override
    public void run()
    {
        L.d("RestoreTerminThread:run:gestarted");
        try
        {
            //File file = new File(Environment.getExternalStorageDirectory().toString(), "/Download/" + name);
            InputStream file = context.getContentResolver().openInputStream(name);
            //
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            explore(root);
            //
            MyDatabaseHelper helper = new MyDatabaseHelper(context);
            SQLiteDatabase db = helper.getWritableDatabase();
            db.delete("termin", null, null);
            for (int i=0;i<termine.size();i++)
            {
                SatzTermin satz = termine.get(i);
                long id = satz.getId();
                int jahr = satz.getJahr();
                int monat = satz.getMonat();
                int tag = satz.getTag();
                int stunde = satz.getStunde();
                int minute = satz.getMinute();
                String beschreibung = satz.getBeschreibung().trim();
                int urlaub = 0;
                ContentValues values = new ContentValues();
                values.put("id",id);
                values.put("jahr",jahr);
                values.put("monat",monat);
                values.put("tag",tag);
                values.put("stunde",stunde);
                values.put("minute",minute);
                values.put("beschreibung",beschreibung);
                values.put("urlaub",0);
                db.insert("termin", null, values);
            }
            db.close();
            //
            Looper.prepare();
            Toast.makeText(context,"RestoreTerminThread:run:restored",Toast.LENGTH_SHORT).show();
        }
        catch (Exception e)
        {
            L.e("RestoreTerminThread:run:Exception:");
            L.e(e.toString());
        }
        L.d("RestoreTerminThread:run:beendet");
    }
    public void explore(Element element)
    {
        long id = 0;
        int jahr = 0;
        int monat = 0;
        int tag = 0;
        int stunde = 0;
        int minute = 0;
        String beschreibung = "";
        NodeList nodeList = element.getChildNodes();
        for (int i=0;i<nodeList.getLength();i++)
        {
            Node node = nodeList.item(i); //Termin
            if (node.getNodeType() == Node.ELEMENT_NODE)
            {
                Element nextElement = (Element) node;
                String elementName = node.getNodeName();
                //L.d("PapierkorbRestoreThread:explore:" + elementName);
                if (elementName.equals("id"))
                {
                    id = Long.parseLong(nextElement.getAttribute("value"));
                }
                if (elementName.equals("jahr"))
                {
                    jahr = Integer.parseInt(nextElement.getAttribute("value"));
                }
                if (elementName.equals("monat"))
                {
                    monat = Integer.parseInt(nextElement.getAttribute("value"));
                }
                if (elementName.equals("tag"))
                {
                    tag = Integer.parseInt(nextElement.getAttribute("value"));
                }
                if (elementName.equals("stunde"))
                {
                    stunde = Integer.parseInt(nextElement.getAttribute("value"));
                }
                if (elementName.equals("minute"))
                {
                    minute = Integer.parseInt(nextElement.getAttribute("value"));
                }
                if (elementName.equals("beschreibung"))
                {
                    beschreibung = nextElement.getTextContent().trim();
                    SatzTermin satz = new SatzTermin();
                    satz.setId(id);
                    satz.setJahr(jahr);
                    satz.setMonat(monat);
                    satz.setTag(tag);
                    satz.setStunde(stunde);
                    satz.setMinute(minute);
                    satz.setBeschreibung(beschreibung);
                    termine.add(satz);
                }
                explore(nextElement);
            }
        }
    }
}
