package org.myoggradio.buforth;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;

import androidx.appcompat.app.AppCompatActivity;

public class PickerActivity extends AppCompatActivity implements View.OnClickListener,DatePicker.OnDateChangedListener {
    private DatePicker date_picker  = null;
    private Button butt_picker = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            setContentView(R.layout.activity_picker);
            date_picker = (DatePicker) findViewById(R.id.date_picker);
            butt_picker = (Button) findViewById(R.id.butt_picker);
            date_picker.setOnDateChangedListener(this);
            butt_picker.setOnClickListener(this);
        }
        catch (Exception e)
        {
            L.e("PickerActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }
    @Override
    public void onDateChanged(DatePicker datePicker, int jahr, int monat, int tag)
    {
        String sjahr = Util.formatInteger(jahr,4);
        String smonat = Util.formatInteger(monat+1,2);
        String stag = Util.formatInteger(tag,2);
        ErfassenActivity.text_datum = stag + "." + smonat + "." + sjahr;
    }

    @Override
    public void onClick(View view)
    {
        if (view == butt_picker)
        {
            Intent erfassenIntent = new Intent(this, ErfassenActivity.class);
            startActivity(erfassenIntent);
            finish();
        }
    }
}