package org.myoggradio.buforth;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;
import java.util.Date;

public class PapierkorbActivity extends AppCompatActivity implements View.OnClickListener , AdapterView.OnItemClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private Button undelete = null;
    private String[] text = null;
    private ArrayList<SatzTermin> temp = null;
    private int position = -1;
    private View position_view = null;
    ArrayAdapter<String> arrayAdapter = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_papierkorb);
        ueberschrift = (TextView) findViewById(R.id.ueberschrift_papierkorb);
        undelete = (Button) findViewById(R.id.undelete);
        undelete.setOnClickListener(this);
        MyDatabaseHelper helper = new MyDatabaseHelper(this);
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select id,jahr,monat,tag,stunde,minute,beschreibung from papierkorb order by zeitpunkt desc limit 50";
        Cursor dbCursor = db.rawQuery(sql,null);
        temp = new ArrayList<SatzTermin>();
        while(dbCursor.moveToNext())
        {
            long id = dbCursor.getLong(0);
            int jahr = dbCursor.getInt(1);
            int monat = dbCursor.getInt(2);
            int tag  = dbCursor.getInt(3);
            int stunde = dbCursor.getInt(4);
            int minute = dbCursor.getInt(5);
            String beschreibung = dbCursor.getString(6).trim();
            SatzTermin satz = new SatzTermin();
            satz.setId(id);
            satz.setJahr(jahr);
            satz.setMonat(monat);
            satz.setTag(tag);
            satz.setStunde(stunde);
            satz.setMinute(minute);
            satz.setBeschreibung(beschreibung);
            temp.add(satz);
        }
        db.close();
        Log.d("MyOggRadioTag","Database kompleted");
        ueberschrift.setText("Waste");
        text = new String[2*temp.size()];
        for (int i=0;i<temp.size();i++)
        {
            SatzTermin termin = temp.get(i);
            String x = Util.formatInteger(termin.getTag(),2) + "." + Util.formatInteger(termin.getMonat(),2) + "." + Util.formatInteger(termin.getJahr(),4);
            x = x + " " + Util.formatInteger(termin.getStunde(),2) + ":" + Util.formatInteger(termin.getMinute(),2);
            text[2*i] = x;
            text[2*i+1] = " " + termin.getBeschreibung().trim();
        };
        l_view = (ListView)findViewById(R.id.list);
        arrayAdapter = new ArrayAdapter<String>(this, R.layout.row, text);
        l_view.setAdapter(arrayAdapter);
        l_view.setOnItemClickListener(this);
        Log.d("MyOggRadioTag","Adapter set");
    }

    @Override
    public void onClick(View view)
    {
        if (view == undelete)
        {
            if (position >= 0) {
                SatzTermin termin = temp.get(position);
                long id = termin.getId();
                MyDatabaseHelper helper = new MyDatabaseHelper(this);
                SQLiteDatabase db = helper.getWritableDatabase();
                db.delete("papierkorb", "id=?", new String[]{""+id});
                ContentValues values = new ContentValues();
                values.put("id",id);
                values.put("jahr",termin.getJahr());
                values.put("monat",termin.getMonat());
                values.put("tag",termin.getTag());
                values.put("stunde",termin.getStunde());
                values.put("minute",termin.getMinute());
                values.put("beschreibung",termin.getBeschreibung().trim());
                values.put("urlaub",0);
                db.insert("termin", null, values);
                db.close();
                Intent papierkorbIntent = new Intent(this, PapierkorbActivity.class);
                startActivity(papierkorbIntent);
                finish();
            }
        }
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l)
    {
        if (position_view != null)
        {
            position_view.setBackgroundColor(Color.GREEN);
        }
        position_view = view;
        view.setBackgroundColor(Color.RED);
        position = i/2;
    }
}