package org.myoggradio.buforth;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;
import java.util.Date;

public class NamenActivity extends AppCompatActivity implements View.OnClickListener , AdapterView.OnItemClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private Button details = null;
    private String[] text = null;
    private ArrayList<SatzTermin> temp = null;
    private int position = -1;
    private View position_view = null;
    ArrayAdapter<String> arrayAdapter = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_namen);
        ueberschrift = (TextView) findViewById(R.id.ueberschrift_namen);
        details = (Button) findViewById(R.id.details);
        details.setOnClickListener(this);
        MyDatabaseHelper helper = new MyDatabaseHelper(this);
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select beschreibung,count(*) from termin group by beschreibung order by beschreibung";
        Cursor dbCursor = db.rawQuery(sql,null);
        temp = new ArrayList<SatzTermin>();
        while(dbCursor.moveToNext())
        {
            String beschreibung = dbCursor.getString(0);
            int anzahl = dbCursor.getInt(1);
            SatzTermin satz = new SatzTermin();
            satz.setJahr(anzahl);
            satz.setBeschreibung(beschreibung);
            temp.add(satz);
        }
        db.close();
        Log.d("MyOggRadioTag","Database kompleted");
        String s= "Group by Description";
        if (temp.size() == 0) s = s + " " + "No Appointments";
        ueberschrift.setText(s);
        text = new String[temp.size()];
        for (int i=0;i<temp.size();i++)
        {
            SatzTermin termin = temp.get(i);
            String x = Util.formatInteger(termin.getJahr(),4) + " " + termin.getBeschreibung();
            text[i] = x;
        };
        l_view = (ListView)findViewById(R.id.list_namen);
        arrayAdapter = new ArrayAdapter<String>(this, R.layout.row, text);
        l_view.setAdapter(arrayAdapter);
        l_view.setOnItemClickListener(this);
        Log.d("MyOggRadioTag","Adapter set");
    }

    @Override
    public void onClick(View view)
    {
        if (view == details)
        {
            if (position >= 0) {
                SatzTermin termin = temp.get(position);
                String name = termin.getBeschreibung();
                MyDatabaseHelper helper = new MyDatabaseHelper(this);
                Intent detailIntent = new Intent(this, DetailActivity.class);
                detailIntent.putExtra("beschreibung", name);
                startActivity(detailIntent);
            }
        }
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l)
    {
        if (position_view != null)
        {
            position_view.setBackgroundColor(Color.GREEN);
        }
        position_view = view;
        view.setBackgroundColor(Color.RED);
        position = i;
    }
}