package org.myoggradio.buforth;

import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Point;
import android.os.CancellationSignal;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsProvider;
import android.provider.DocumentsContract;
import androidx.annotation.Nullable;

import java.io.File;
import java.io.FileNotFoundException;

public class MyXmlDocumentProvider extends DocumentsProvider
{
    private static final String ROOT_ID = "root_id";
    private static final String FILE_NAME = "/Download/buforth_backup_appointment.xml";
    private static final String XML_MIME_TYPE = "*/*";
    @Override
    public Cursor queryRoots(String[] projection) throws FileNotFoundException {
        L.d("MyXmlDocumentProvider:queryRoots");
        final MatrixCursor result = new MatrixCursor(
                new String[]
                        {
                                DocumentsContract.Root.COLUMN_ROOT_ID,
                                DocumentsContract.Root.COLUMN_DOCUMENT_ID,
                                DocumentsContract.Root.COLUMN_TITLE,
                                DocumentsContract.Root.COLUMN_FLAGS,
                                DocumentsContract.Root.COLUMN_MIME_TYPES
                        }
        );
        result.newRow()
                .add(DocumentsContract.Root.COLUMN_ROOT_ID,ROOT_ID)
                .add(DocumentsContract.Root.COLUMN_DOCUMENT_ID,ROOT_ID)
                .add(DocumentsContract.Root.COLUMN_TITLE,"XML_Speicher")
                .add(DocumentsContract.Root.COLUMN_FLAGS,DocumentsContract.Root.FLAG_SUPPORTS_CREATE)
                .add(DocumentsContract.Root.COLUMN_MIME_TYPES,XML_MIME_TYPE);
        return result;
    }

    @Override
    public Cursor queryDocument(String documentId, String[] projection) throws FileNotFoundException {
        L.d("MyXmlDocumentProvider:queryDocument");
        final MatrixCursor result = new MatrixCursor(
                new String[]
                        {
                                DocumentsContract.Document.COLUMN_DOCUMENT_ID,
                                DocumentsContract.Document.COLUMN_DISPLAY_NAME,
                                DocumentsContract.Document.COLUMN_MIME_TYPE,
                                DocumentsContract.Document.COLUMN_FLAGS,
                                DocumentsContract.Document.COLUMN_SIZE
                        }
        );
        result.newRow()
                .add(DocumentsContract.Document.COLUMN_DOCUMENT_ID,documentId)
                .add(DocumentsContract.Document.COLUMN_DISPLAY_NAME,FILE_NAME)
                .add(DocumentsContract.Document.COLUMN_MIME_TYPE,XML_MIME_TYPE)
                .add(DocumentsContract.Document.COLUMN_FLAGS,DocumentsContract.Document.FLAG_SUPPORTS_WRITE)
                .add(DocumentsContract.Document.COLUMN_SIZE,1024);
        return result;
    }

    @Override
    public Cursor queryChildDocuments(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        L.d("MyXmlDocumentProvider:queryChildDocuments");
        final MatrixCursor result = new MatrixCursor(
                new String[]
                        {
                                DocumentsContract.Document.COLUMN_DOCUMENT_ID,
                                DocumentsContract.Document.COLUMN_DISPLAY_NAME,
                                DocumentsContract.Document.COLUMN_MIME_TYPE,
                                DocumentsContract.Document.COLUMN_FLAGS,
                                DocumentsContract.Document.COLUMN_SIZE
                        }
        );
        result.newRow()
                .add(DocumentsContract.Document.COLUMN_DOCUMENT_ID,FILE_NAME)
                .add(DocumentsContract.Document.COLUMN_DISPLAY_NAME,FILE_NAME)
                .add(DocumentsContract.Document.COLUMN_MIME_TYPE,XML_MIME_TYPE)
                .add(DocumentsContract.Document.COLUMN_FLAGS,DocumentsContract.Document.FLAG_SUPPORTS_WRITE)
                .add(DocumentsContract.Document.COLUMN_SIZE,1024);
        return result;
    }

    @Override
    public ParcelFileDescriptor openDocument(String documentId, String mode, @Nullable CancellationSignal signal) throws FileNotFoundException
    {
        L.d("MyXmlDocumentProvider:openDocument");
        try {
            File file = new File(Environment.getExternalStorageDirectory().toString(), FILE_NAME);
            if (mode.contains("w")) {
                return ParcelFileDescriptor.open(file,
                        ParcelFileDescriptor.MODE_WRITE_ONLY | ParcelFileDescriptor.MODE_CREATE | ParcelFileDescriptor.MODE_TRUNCATE);
            } else if (mode.contains("r")) {
                return ParcelFileDescriptor.open(file,
                        ParcelFileDescriptor.MODE_READ_ONLY);
            }
            throw new FileNotFoundException("Unsupported mode:" + mode);
        }
        catch (Exception e)
        {
            L.e("MyXmlDocumentProvider:openDocumnt:Exception:");
            L.e(e.toString());
        }
        return null;
    }

    @Override
    public boolean onCreate() {
        L.d("MyXmlDocumentProvider:onCreate");
        return true;
    }

    @Override
    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint,CancellationSignal signal)
    {
        L.d("MyXmlDocumentProvider:openDocumentThumbnail");
        return null;
    }
}
