package org.myoggradio.buforth;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import androidx.annotation.Nullable;

public class MyDatabaseHelper extends SQLiteOpenHelper {
    public MyDatabaseHelper(@Nullable Context context) {
        super(context,"Termine", null, 1);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        try
        {
            String sql = "create table termin (";
            sql += " id bigint not null,";
            sql += " jahr integer not null,";
            sql += " monat integer not null,";
            sql += " tag integer not null,";
            sql += " stunde integer not null,";
            sql += " minute integer not null,";
            sql += " beschreibung varchar(255) not null,";
            sql += " urlaub integer not null)";
            db.execSQL(sql);
            sql = "create table papierkorb (";
            sql += " id bigint not null,";
            sql += " jahr integer not null,";
            sql += " monat integer not null,";
            sql += " tag integer not null,";
            sql += " stunde integer not null,";
            sql += " minute integer not null,";
            sql += " beschreibung varchar(255) not null,";
            sql += " urlaub integer not null,";
            sql += " zeitpunkt bigint not null)";
            db.execSQL(sql);
            sql = "create unique index ui1_termin on termin";
            sql += " (id)";
            db.execSQL(sql);
            sql = "create index i1_termin on termin";
            sql += " (jahr,monat,tag)";
            db.execSQL(sql);
        }
        catch (Exception e)
        {
            L.e("MyDatabaseHelper:onCreate");
            L.e(e.toString());
        }
    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {

    }
}