package org.myoggradio.buforth;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import androidx.appcompat.app.AppCompatActivity;

import java.time.LocalDate;

public class MenuActivity extends AppCompatActivity implements View.OnClickListener {
    private Button uebersicht = null;
    private Button erfassen = null;
    private Button letzte = null;
    private Button papierkorb = null;
    private Button namen = null;
    private Button naechste = null;
    private Button backup = null;
    private Button restore_termin = null;
    private int ijahr = 0;
    private int imonat = 0;
    private final int requestCode = 0;
    private final int requestCodeCreate = 1;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = getIntent();
            if (intent == null)
            {
                ijahr = LocalDate.now().getYear();
                imonat = LocalDate.now().getMonthValue();
            }
            else
            {
                String sjahr = intent.getStringExtra("jahr");
                String smonat = intent.getStringExtra("monat");
                if (sjahr == null) sjahr = "-1";
                if (smonat == null) smonat = "-1";
                ijahr = Integer.parseInt(sjahr);
                imonat = Integer.parseInt(smonat);
                if (ijahr < 0) ijahr = LocalDate.now().getYear();
                if (imonat < 0) imonat = LocalDate.now().getMonthValue();
            }
            setContentView(R.layout.activity_menu);
            uebersicht= (Button) findViewById(R.id.uebersicht);
            erfassen = (Button) findViewById(R.id.erfassen);
            letzte = (Button) findViewById(R.id.letzte);
            papierkorb = (Button) findViewById(R.id.papierkorb);
            namen = (Button) findViewById(R.id.namen);
            naechste = (Button) findViewById(R.id.naechste);
            backup = (Button) findViewById(R.id.backup);
            restore_termin = (Button) findViewById(R.id.restore_termin);
            uebersicht.setOnClickListener(this);
            erfassen.setOnClickListener(this);
            letzte.setOnClickListener(this);
            papierkorb.setOnClickListener(this);
            namen.setOnClickListener(this);
            naechste.setOnClickListener(this);
            backup.setOnClickListener(this);
            restore_termin.setOnClickListener(this);
          }
        catch (Exception e)
        {
            L.e("MenuActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }

    @Override
    public void onClick(View view) {
        if (view == uebersicht)
        {
            //Intent mainIntent = new Intent(this, MainActivity.class);
            //mainIntent.putExtra("jahr","" + ijahr);
            //mainIntent.putExtra("monat","" + imonat);
            //startActivity(mainIntent);
            finish();
        }
        if (view == erfassen)
        {
            Intent erfassenIntent = new Intent(this, ErfassenActivity.class);
            startActivity(erfassenIntent);
            finish();
        }
        if (view == letzte)
        {
            Intent letzteIntent = new Intent(this, LetzteActivity.class);
            startActivity(letzteIntent);
            finish();
        }
        if (view == papierkorb)
        {
            Intent papierkorbIntent = new Intent(this, PapierkorbActivity.class);
            startActivity(papierkorbIntent);
            finish();
        }
        if (view == naechste)
        {
            Intent naechsteIntent = new Intent(this, NaechsteActivity.class);
            startActivity(naechsteIntent);
            finish();
        }
        if (view == namen)
        {
            Intent namenIntent = new Intent(this, NamenActivity.class);
            startActivity(namenIntent);
            finish();
        }
        if (view == backup)
        {
            Intent intent = new Intent(Intent.ACTION_CREATE_DOCUMENT);
            intent.setType("*/*");
            intent.putExtra(Intent.EXTRA_TITLE,"backup.xml");
            startActivityForResult(intent,requestCodeCreate);
        }
        if (view == restore_termin)
        {
            Intent intent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
            intent.addCategory(Intent.CATEGORY_OPENABLE);
            intent.setType("*/*");
            intent.putExtra(Intent.EXTRA_TITLE,"backup.xml");
            startActivityForResult(intent,requestCode);
            /*
            Intent restoreIntent = new Intent(this, RestoreTerminActivity.class);
            startActivity(restoreIntent);
            finish();
            */
        }
    }
    @Override
    protected void onActivityResult(int rCode,int resultCode,Intent data)
    {
        super.onActivityResult(requestCode,resultCode,data);
        if (rCode == requestCode && resultCode == MenuActivity.RESULT_OK)
        {
            if (data != null)
            {
                Uri uri = data.getData();
                RestoreTerminThread thread = new RestoreTerminThread(this.getBaseContext(),uri);
                thread.start();
                finish();
            }
        }
        if (rCode == requestCodeCreate && resultCode == MenuActivity.RESULT_OK)
        {
            if (data != null)
            {
                Uri uri = data.getData();
                BackupThread thread = new BackupThread(this.getBaseContext(),uri);
                thread.start();
                finish();
            }
        }
    }
}