package org.myoggradio.buforth;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.GridLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import java.time.LocalDate;

public class MainActivity extends AppCompatActivity implements View.OnClickListener , View.OnTouchListener , GestureDetector.OnGestureListener {

    private DayButton[][] butts = new DayButton[7][7];
    private GridLayout kalender = null;
    private LinearLayout main_view = null;
    private TextView jahr = null;
    private TextView monat = null;
    private Button jahrplus = null;
    private Button jahrminus = null;
    private Button monatplus = null;
    private Button monatminus = null;
    private Button menu = null;
    private Button refresh = null;
    private int ijahr = 0;
    private int imonat = 0;
    private GestureDetector detector = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = getIntent();
            if (intent == null)
            {
                ijahr = LocalDate.now().getYear();
                imonat = LocalDate.now().getMonthValue();
            }
            else
            {
                String sjahr = intent.getStringExtra("jahr");
                String smonat = intent.getStringExtra("monat");
                if (sjahr == null) sjahr = "-1";
                if (smonat == null) smonat = "-1";
                ijahr = Integer.parseInt(sjahr);
                imonat = Integer.parseInt(smonat);
                if (ijahr < 0) ijahr = LocalDate.now().getYear();
                if (imonat < 0) imonat = LocalDate.now().getMonthValue();
            }
            setContentView(R.layout.activity_main);
            kalender = (GridLayout) findViewById(R.id.kalender);
            main_view = (LinearLayout) findViewById(R.id.main_view);
            jahr = (TextView) findViewById(R.id.jahr);
            monat = (TextView) findViewById(R.id.monat);
            jahrplus = (Button) findViewById(R.id.jahrplus);
            jahrminus = (Button) findViewById(R.id.jahrminus);
            monatplus = (Button) findViewById(R.id.monatplus);
            monatminus = (Button) findViewById(R.id.monatminus);
            menu = (Button) findViewById(R.id.menu);
            refresh = (Button) findViewById(R.id.refresh);
            jahrplus.setOnClickListener(this);
            jahrminus.setOnClickListener(this);
            monatplus.setOnClickListener(this);
            monatminus.setOnClickListener(this);
            menu.setOnClickListener(this);
            jahr.setText("" + ijahr);
            monat.setText("" + imonat);
            refresh.setOnClickListener(this);
            doRefresh();
            main_view.setOnTouchListener(this);
            detector = new GestureDetector(this,this);
        }
        catch (Exception e)
        {
            L.e("MainActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }
    public void doRefresh()
    {
        try {
            for (int i = 0; i < 7; i++) {
                for (int j = 0; j < 7; j++) {
                    butts[i][j] = getDayButton(i, j);
                    butts[i][j].setOnClickListener(this);
                    GridLayout.LayoutParams params = new GridLayout.LayoutParams();
                    params.rowSpec = GridLayout.spec(j);
                    params.columnSpec = GridLayout.spec(i);
                    params.width = 90;
                    butts[i][j].setLayoutParams(params);
                    kalender.addView(butts[i][j]);
                    //MyDatabaseHelper helper = new MyDatabaseHelper(this);
                    //SQLiteDatabase db = helper.getWritableDatabase();
                    //db.close();
                }
            }
        }
        catch (Exception e)
        {
            L.e("MainActivity:doRefresh:Exception:");
            L.e(e.toString());
        }
    }
    private DayButton getDayButton(int col,int row)
    {
        DayButton erg = new DayButton(this.getBaseContext());
        if (row == 0)
        {
            erg.setNumber(0);
            erg.setColor(Color.WHITE);
            if (col == 0) erg.setText("Mon");
            if (col == 1) erg.setText("Tue");
            if (col == 2) erg.setText("Wed");
            if (col == 3) erg.setText("Thu");
            if (col == 4) erg.setText("Fri");
            if (col == 5) erg.setText("Sat");
            if (col == 6) erg.setText("Sun");
        }
        else
        {
            row--;
            LocalDate erster = LocalDate.of(ijahr,imonat,1);
            int offset = erster.getDayOfWeek().getValue();
            if (offset == 0) offset = 7;
            offset--;
            int pos = 7*row + col - offset;
            if (pos < 0 | pos > 30)
            {
                erg.setNumber(0);
                erg.setText("");
                erg.setColor(Color.WHITE);
            }
            else
            {
                erg.setNumber(pos+1);
                int argb = getButtonColor(ijahr,imonat,pos+1);
                erg.setColor(argb);
            }
            if (notExists(ijahr,imonat,pos+1))
            {
                erg.setNumber(0);
                erg.setText("");
                erg.setColor(Color.WHITE);
            }
        }
        return erg;
    }
    public boolean notExists(int jahr,int monat,int tag)
    {
        boolean erg = false;
        try {
            LocalDate datum = LocalDate.of(jahr,monat,tag);
        }
        catch (Exception e)
        {
            erg = true;
        }
        return erg;
    }
    public int getButtonColor(int jahr,int monat,int tag)
    {
        int erg = Color.WHITE;
        try {
            MyDatabaseHelper helper = new MyDatabaseHelper(this);
            SQLiteDatabase db = helper.getReadableDatabase();
            String sql = "select count(*) from termin where jahr = ? and monat = ? and tag = ?";
            Cursor dbCursor = db.rawQuery(sql, new String[]{"" + jahr, "" + monat, "" + tag});
            int anzahl = 0;
            while (dbCursor.moveToNext()) {
                anzahl = dbCursor.getInt(0);
            }
            dbCursor.close();
            db.close();
            if (anzahl == 0) erg = Color.WHITE;
            else if (anzahl == 1) erg = Color.GREEN;
            else if (anzahl == 2 | anzahl == 3) erg = Color.YELLOW;
            else erg = Color.RED;
        }
        catch (Exception e)
        {
            L.e("MainActivity:getButtonColor:Exception:");
            L.e(e.toString());
        }
        return erg;
    }
    @Override
    public void onClick(View view) {
        if (view == refresh)
        {
            doRefresh();
        }
        if (view == menu)
        {
            Intent menuIntent = new Intent(this, MenuActivity.class);
            menuIntent.putExtra("jahr","" + ijahr);
            menuIntent.putExtra("monat","" + imonat);
            startActivity(menuIntent);
            //finish();
        }
        if (view == jahrplus)
        {
            Intent mainIntent = new Intent(this, MainActivity.class);
            mainIntent.putExtra("jahr","" + (ijahr+1));
            mainIntent.putExtra("monat","" + imonat);
            startActivity(mainIntent);
            finish();
        }
        if (view == jahrminus)
        {
            Intent mainIntent = new Intent(this, MainActivity.class);
            mainIntent.putExtra("jahr","" + (ijahr-1));
            mainIntent.putExtra("monat","" + imonat);
            startActivity(mainIntent);
            finish();
        }
        if (view == monatplus)
        {
            imonat++;
            if (imonat > 12)
            {
                imonat = 1;
                ijahr++;
            }
            Intent mainIntent = new Intent(this, MainActivity.class);
            mainIntent.putExtra("jahr","" + ijahr);
            mainIntent.putExtra("monat","" + imonat);
            startActivity(mainIntent);
            finish();
        }
        if (view == monatminus)
        {
            imonat--;
            if (imonat < 1)
            {
                imonat = 12;
                ijahr--;
            }
            Intent mainIntent = new Intent(this, MainActivity.class);
            mainIntent.putExtra("jahr","" + ijahr);
            mainIntent.putExtra("monat","" + imonat);
            startActivity(mainIntent);
            finish();
        }
        for (int i=0;i<7;i++)
        {
            for (int j=0;j<7;j++)
            {
                if (view == butts[i][j])
                {
                    int itag = butts[i][j].getNumber();
                    if (itag != 0) {
                        L.d("" + butts[i][j].getNumber());
                        Intent einIntent = new Intent(this, EinActivity.class);
                        einIntent.putExtra("jahr", "" + ijahr);
                        einIntent.putExtra("monat", "" + imonat);
                        einIntent.putExtra("tag", "" + itag);
                        startActivity(einIntent);
                    }
                }
            }
        }
    }

    @Override
    public boolean onTouch(View view, MotionEvent me)
    {
        L.d("MainActivity:onTouch:started");
        return detector.onTouchEvent(me);
    }

    @Override
    public boolean onDown(@NonNull MotionEvent motionEvent)
    {
        L.d("MainActivity:onDown:started");
        return true;
    }

    @Override
    public void onShowPress(@NonNull MotionEvent motionEvent) {
        L.d("MainActivity:onShowPress:started");
    }

    @Override
    public boolean onSingleTapUp(@NonNull MotionEvent motionEvent)
    {
        L.d("MainActivity:onSingleTabUp:started");
        return true;
    }

    @Override
    public boolean onScroll(@Nullable MotionEvent motionEvent, @NonNull MotionEvent motionEvent1, float v, float v1)
    {
        L.d("MainActivity:onScroll:started");
        return true;
    }

    @Override
    public void onLongPress(@NonNull MotionEvent motionEvent)
    {
        L.d("MainActivity:onLongPressed:started");
    }

    @Override
    public boolean onFling(@Nullable MotionEvent me1, @NonNull MotionEvent me2, float v1, float v2)
    {
        L.d("MainActivity:onFling:started");
        if (v1 > 10)
        {
            imonat++;
            if (imonat > 12)
            {
                imonat = 1;
                ijahr++;
            }
            Intent mainIntent = new Intent(this, MainActivity.class);
            mainIntent.putExtra("jahr","" + ijahr);
            mainIntent.putExtra("monat","" + imonat);
            startActivity(mainIntent);
            finish();
        }
        else if (v1 < -10)
        {
            imonat--;
            if (imonat < 1)
            {
                imonat = 12;
                ijahr--;
            }
            Intent mainIntent = new Intent(this, MainActivity.class);
            mainIntent.putExtra("jahr","" + ijahr);
            mainIntent.putExtra("monat","" + imonat);
            startActivity(mainIntent);
            finish();
        }
        return true;
    }
}