package org.myoggradio.buforth;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import androidx.appcompat.app.AppCompatActivity;

import java.util.Date;

public class ErfassenActivity extends AppCompatActivity implements View.OnClickListener{
    public static String text_datum = null;
    public static String text_zeit = null;
    public static String text_beschreibung = null;
    private EditText datum_daten  = null;
    private EditText zeit_daten = null;
    private EditText beschreibung_daten = null;
    private Button erfassen = null;
    private Button picker_button = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            setContentView(R.layout.activity_erfassen);
            datum_daten= (EditText) findViewById(R.id.datum_daten);
            zeit_daten= (EditText) findViewById(R.id.zeit_daten);
            beschreibung_daten = (EditText) findViewById(R.id.beschreibung_daten);
            erfassen = (Button) findViewById(R.id.erfassen_button);
            picker_button = (Button) findViewById(R.id.picker_button);
            erfassen.setOnClickListener(this);
            picker_button.setOnClickListener(this);
            if (text_datum != null) datum_daten.setText(text_datum);
            if (text_zeit != null) zeit_daten.setText(text_zeit);
            if (text_beschreibung != null) beschreibung_daten.setText(text_beschreibung);
        }
        catch (Exception e)
        {
            L.e("ErfassenActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }
    @Override
    public void onClick(View view) {
        if (view == erfassen)
        {
            try{
                String datum = datum_daten.getText().toString();
                String zeit = zeit_daten.getText().toString();
                L.d("ErfassenActivity:onClick:Datum:" + datum);
                L.d("ErfassenActivity:onClick:Zeit :" + zeit);
                String stag = datum.substring(0,2);
                String smonat = datum.substring(3,5);
                String sjahr  = datum.substring(6,10);
                String sstunde = zeit.substring(0,2);
                String sminute = zeit.substring(3,5);
                String beschreibung = beschreibung_daten.getText().toString();
                //
                MyDatabaseHelper helper = new MyDatabaseHelper(this);
                SQLiteDatabase db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("id",new Date().getTime());
                values.put("jahr",Integer.parseInt(sjahr));
                values.put("monat",Integer.parseInt(smonat));
                values.put("tag",Integer.parseInt(stag));
                values.put("stunde",Integer.parseInt(sstunde));
                values.put("minute",Integer.parseInt(sminute));
                values.put("beschreibung",beschreibung.trim());
                values.put("urlaub",0);
                long newRowId = db.insert("termin", null, values);
                Intent mainIntent = new Intent(this, MainActivity.class);
                startActivity(mainIntent);
                finish();
            }
            catch (Exception e)
            {
                L.e("ErfassenActivity:onClick:erfassen:Exception:");
                L.e(e.toString());
            }
        }
        if (view == picker_button)
        {
            Intent pickerIntent = new Intent(this, PickerActivity.class);
            text_zeit = zeit_daten.getText().toString();
            text_datum = datum_daten.getText().toString();
            text_beschreibung = beschreibung_daten.getText().toString();
            startActivity(pickerIntent);
            finish();
        }
    }
}