package org.myoggradio.buforth;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;
import java.util.Date;

public class EinActivity extends AppCompatActivity implements View.OnClickListener , AdapterView.OnItemClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private Button loeschen = null;
    private Button erfassen = null;
    private String[] text = null;
    private ArrayList<SatzTermin> temp = null;
    private int position = -1;
    ArrayAdapter<String> arrayAdapter = null;
    String jahr = null;
    String monat = null;
    String tag = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = getIntent();
        jahr = intent.getStringExtra("jahr");
        monat = intent.getStringExtra("monat");
        tag = intent.getStringExtra("tag");
        setContentView(R.layout.activity_ein);
        ueberschrift = (TextView) findViewById(R.id.ueberschrift);
        loeschen = (Button) findViewById(R.id.loeschen);
        erfassen = (Button) findViewById(R.id.erfassen_butt);
        loeschen.setOnClickListener(this);
        erfassen.setOnClickListener(this);
        MyDatabaseHelper helper = new MyDatabaseHelper(this);
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select id,jahr,monat,tag,stunde,minute,beschreibung from termin where jahr = ? and monat = ? and tag = ? order by stunde,minute,id";
        Cursor dbCursor = db.rawQuery(sql,new String[]{jahr,monat,tag});
        temp = new ArrayList<SatzTermin>();
        while(dbCursor.moveToNext())
        {
            long id = dbCursor.getLong(0);
            int jahr = dbCursor.getInt(1);
            int monat = dbCursor.getInt(2);
            int tag  = dbCursor.getInt(3);
            int stunde = dbCursor.getInt(4);
            int minute = dbCursor.getInt(5);
            String beschreibung = dbCursor.getString(6);
            SatzTermin satz = new SatzTermin();
            satz.setId(id);
            satz.setJahr(jahr);
            satz.setMonat(monat);
            satz.setTag(tag);
            satz.setStunde(stunde);
            satz.setMinute(minute);
            satz.setBeschreibung(beschreibung.trim());
            temp.add(satz);
        }
        db.close();
        Log.d("MyOggRadioTag","Database kompleted");
        String s = Util.formatInteger(Integer.parseInt(tag),2) + "." + Util.formatInteger(Integer.parseInt(monat),2) + "." + Util.formatInteger(Integer.parseInt(jahr),4);
        if (temp.size() == 0) s = s + " " + "No Appointments";
        ueberschrift.setText(s);
        text = new String[2*temp.size()];
        for (int i=0;i<temp.size();i++)
        {
            SatzTermin termin = temp.get(i);
            String x = Util.formatInteger(termin.getTag(),2) + "." + Util.formatInteger(termin.getMonat(),2) + "." + Util.formatInteger(termin.getJahr(),4);
            x = x + " " + Util.formatInteger(termin.getStunde(),2) + ":" + Util.formatInteger(termin.getMinute(),2);
            text[2*i] = x;
            text[2*i+1] = " " + termin.getBeschreibung();
        };
        l_view = (ListView)findViewById(R.id.list);
        arrayAdapter = new ArrayAdapter<String>(this, R.layout.row, text);
        l_view.setAdapter(arrayAdapter);
        l_view.setOnItemClickListener(this);
        Log.d("MyOggRadioTag","Adapter set");
    }

    @Override
    public void onClick(View view)
    {
        if (view == erfassen)
        {
            String sjahr = Util.formatInteger(Integer.parseInt(jahr),4);
            String smonat = Util.formatInteger(Integer.parseInt(monat),2);
            String stag = Util.formatInteger(Integer.parseInt(tag),2);
            ErfassenActivity.text_datum = stag + "." + smonat + "." + sjahr;
            Intent erfassenIntent = new Intent(this, ErfassenActivity.class);
            startActivity(erfassenIntent);
            finish();
        }
        if (view == loeschen)
        {
            if (position >= 0) {
                SatzTermin termin = temp.get(position);
                long id = termin.getId();
                MyDatabaseHelper helper = new MyDatabaseHelper(this);
                SQLiteDatabase db = helper.getWritableDatabase();
                db.delete("termin", "id=?", new String[]{""+id});
                ContentValues values = new ContentValues();
                values.put("id",id);
                values.put("jahr",termin.getJahr());
                values.put("monat",termin.getMonat());
                values.put("tag",termin.getTag());
                values.put("stunde",termin.getStunde());
                values.put("minute",termin.getMinute());
                values.put("beschreibung",termin.getBeschreibung().trim());
                values.put("urlaub",0);
                values.put("zeitpunkt",new Date().getTime());
                db.insert("papierkorb", null, values);
                db.close();
                Intent einIntent = new Intent(this, EinActivity.class);
                einIntent.putExtra("jahr", jahr);
                einIntent.putExtra("monat", monat);
                einIntent.putExtra("tag", tag);
                startActivity(einIntent);
                finish();
            }
        }
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l)
    {
        position = i/2;
    }
}