package org.myoggradio.buforth;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;
import java.util.Date;

public class DetailActivity extends AppCompatActivity implements View.OnClickListener , AdapterView.OnItemClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private String[] text = null;
    private ArrayList<SatzTermin> temp = null;
    private int position = -1;
    private View position_view = null;
    ArrayAdapter<String> arrayAdapter = null;
    String beschreibung = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = getIntent();
        beschreibung = intent.getStringExtra("beschreibung");
        setContentView(R.layout.activity_detail);
        ueberschrift = (TextView) findViewById(R.id.ueberschrift_detail);
        MyDatabaseHelper helper = new MyDatabaseHelper(this);
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select id,jahr,monat,tag,stunde,minute,beschreibung from termin where beschreibung = ? order by jahr desc,monat desc ,tag desc ,stunde desc,minute desc,id desc";
        Cursor dbCursor = db.rawQuery(sql,new String[]{beschreibung});
        temp = new ArrayList<SatzTermin>();
        while(dbCursor.moveToNext())
        {
            long id = dbCursor.getLong(0);
            int jahr = dbCursor.getInt(1);
            int monat = dbCursor.getInt(2);
            int tag  = dbCursor.getInt(3);
            int stunde = dbCursor.getInt(4);
            int minute = dbCursor.getInt(5);
            String beschreibung = dbCursor.getString(6);
            SatzTermin satz = new SatzTermin();
            satz.setId(id);
            satz.setJahr(jahr);
            satz.setMonat(monat);
            satz.setTag(tag);
            satz.setStunde(stunde);
            satz.setMinute(minute);
            satz.setBeschreibung(beschreibung);
            temp.add(satz);
        }
        db.close();
        Log.d("MyOggRadioTag","Database kompleted");

        String s = "All Appointments with same Description";
        if (temp.size() == 0) s = s + " " + "No Appointments";
        ueberschrift.setText(s);
        text = new String[2*temp.size()];
        for (int i=0;i<temp.size();i++)
        {
            SatzTermin termin = temp.get(i);
            String x = Util.formatInteger(termin.getTag(),2) + "." + Util.formatInteger(termin.getMonat(),2) + "." + Util.formatInteger(termin.getJahr(),4);
            x = x + " " + Util.formatInteger(termin.getStunde(),2) + ":" + Util.formatInteger(termin.getMinute(),2);
            text[2*i] = x;
            text[2*i+1] = " " + termin.getBeschreibung();
        };
        l_view = (ListView)findViewById(R.id.list_detail);
        arrayAdapter = new ArrayAdapter<String>(this, R.layout.row, text);
        l_view.setAdapter(arrayAdapter);
        l_view.setOnItemClickListener(this);
        Log.d("MyOggRadioTag","Adapter set");
    }

    @Override
    public void onClick(View view)
    {

    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l)
    {
        if (position_view != null)
        {
            position_view.setBackgroundColor(Color.GREEN);
        }
        position_view = view;
        view.setBackgroundColor(Color.RED);
        position = i/2;
    }
}