package org.myoggradio.buforth;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Environment;
import android.os.Looper;
import android.widget.Toast;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class BackupThread extends Thread
{
    private Context context = null;
    private Uri uri = null;
    public BackupThread(Context context,Uri uri)
    {
        this.uri = uri;
        this.context = context;
    }
    @Override
    public void run()
    {
        L.d("BackupThread:run:gestarted");
        try
        {
            String pattern = "yyyy_MM_dd_HH_mm_ss";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            String prefix = LocalDateTime.now().format(formatter);
            //File file = new File(Environment.getExternalStorageDirectory().toString(), "/Download/buforth_backup_appointment.xml");
            //File file2 = new File(Environment.getExternalStorageDirectory().toString(), "/Download/buforth_backup_waste.xml");
            //
            OutputStream file = context.getContentResolver().openOutputStream(uri);
            MyDatabaseHelper helper = new MyDatabaseHelper(context);
            SQLiteDatabase db = helper.getReadableDatabase();
            String sql = "select id,jahr,monat,tag,stunde,minute,beschreibung from termin";
            Cursor dbCursor = db.rawQuery(sql,null);
            ArrayList<SatzTermin> termine = new ArrayList<SatzTermin>();
            while(dbCursor.moveToNext())
            {
                long id = dbCursor.getLong(0);
                int jahr = dbCursor.getInt(1);
                int monat = dbCursor.getInt(2);
                int tag  = dbCursor.getInt(3);
                int stunde = dbCursor.getInt(4);
                int minute = dbCursor.getInt(5);
                String beschreibung = dbCursor.getString(6);
                SatzTermin satz = new SatzTermin();
                satz.setId(id);
                satz.setJahr(jahr);
                satz.setMonat(monat);
                satz.setTag(tag);
                satz.setStunde(stunde);
                satz.setMinute(minute);
                satz.setBeschreibung(beschreibung);
                termine.add(satz);
            }
            /*
            String sql2 = "select id,jahr,monat,tag,stunde,minute,beschreibung,zeitpunkt from papierkorb";
            Cursor dbCursor2 = db.rawQuery(sql2,null);
            ArrayList<SatzPapierkorb> papierkorb = new ArrayList<SatzPapierkorb>();
            while(dbCursor2.moveToNext())
            {
                long id = dbCursor2.getLong(0);
                int jahr = dbCursor2.getInt(1);
                int monat = dbCursor2.getInt(2);
                int tag  = dbCursor2.getInt(3);
                int stunde = dbCursor2.getInt(4);
                int minute = dbCursor2.getInt(5);
                String beschreibung = dbCursor2.getString(6);
                long zeitpunkt = dbCursor2.getLong(7);
                SatzPapierkorb satz = new SatzPapierkorb();
                satz.setId(id);
                satz.setJahr(jahr);
                satz.setMonat(monat);
                satz.setTag(tag);
                satz.setStunde(stunde);
                satz.setMinute(minute);
                satz.setBeschreibung(beschreibung);
                satz.setZeitpunkt(zeitpunkt);
                papierkorb.add(satz);
            }
            db.close();
            */
            L.d("BackupThread:run:Database ok");
            //
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docb = dbf.newDocumentBuilder();
            Document doc = docb.newDocument();
            Element root = doc.createElement("BackupTermin");
            doc.appendChild(root);
            for (int i=0;i<termine.size();i++)
            {
                SatzTermin satz = termine.get(i);
                Element termin = doc.createElement("Termin");
                long id = satz.getId();
                Element eid = doc.createElement("id");
                eid.setAttribute("value",id + "");
                termin.appendChild(eid);
                int jahr = satz.getJahr();
                Element ejahr = doc.createElement("jahr");
                ejahr.setAttribute("value",jahr + "");
                termin.appendChild(ejahr);
                int monat = satz.getMonat();
                Element emonat = doc.createElement("monat");
                emonat.setAttribute("value",monat + "");
                termin.appendChild(emonat);
                int tag = satz.getTag();
                Element etag = doc.createElement("tag");
                etag.setAttribute("value",tag + "");
                termin.appendChild(etag);
                int stunde = satz.getStunde();
                Element estunde = doc.createElement("stunde");
                estunde.setAttribute("value",stunde + "");
                termin.appendChild(estunde);
                int minute = satz.getMinute();
                Element eminute = doc.createElement("minute");
                eminute.setAttribute("value",minute + "");
                termin.appendChild(eminute);
                String beschreibung = satz.getBeschreibung();
                Element ebeschreibung = doc.createElement("beschreibung");
                Text text = doc.createTextNode(beschreibung.trim());
                ebeschreibung.appendChild(text);
                termin.appendChild(ebeschreibung);
                root.appendChild(termin);
            }
            L.d("BackupThread:run:doc ok");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
            L.d("BackupThread:run:doc written");
            //
            /*
            DocumentBuilderFactory dbf2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder docb2 = dbf2.newDocumentBuilder();
            Document doc2 = docb2.newDocument();
            Element root2 = doc2.createElement("BackupPapierkorb");
            doc2.appendChild(root2);
            for (int i=0;i<papierkorb.size();i++)
            {
                SatzPapierkorb satz = papierkorb.get(i);
                Element termin = doc2.createElement("Termin");
                //
                long id = satz.getId();
                Element eid = doc2.createElement("id");
                eid.setAttribute("value",id + "");
                termin.appendChild(eid);
                //
                int jahr = satz.getJahr();
                Element ejahr = doc2.createElement("jahr");
                ejahr.setAttribute("value",jahr + "");
                termin.appendChild(ejahr);
                //
                int monat = satz.getMonat();
                Element emonat = doc2.createElement("monat");
                emonat.setAttribute("value",monat + "");
                termin.appendChild(emonat);
                //
                int tag = satz.getTag();
                Element etag = doc2.createElement("tag");
                etag.setAttribute("value",tag + "");
                termin.appendChild(etag);
                //
                int stunde = satz.getStunde();
                Element estunde = doc2.createElement("stunde");
                estunde.setAttribute("value",stunde + "");
                termin.appendChild(estunde);
                //
                int minute = satz.getMinute();
                Element eminute = doc2.createElement("minute");
                eminute.setAttribute("value",minute + "");
                termin.appendChild(eminute);
                //
                String beschreibung = satz.getBeschreibung();
                Element ebeschreibung = doc2.createElement("beschreibung");
                Text text = doc2.createTextNode(beschreibung);
                ebeschreibung.appendChild(text);
                termin.appendChild(ebeschreibung);
                //
                long zeitpunkt = satz.getZeitpunkt();
                Element ezeitpunkt = doc2.createElement("zeitpunkt");
                ezeitpunkt.setAttribute("value",zeitpunkt + "");
                termin.appendChild(ezeitpunkt);
                //
                root2.appendChild(termin);
            }
            L.d("BackupThread:run:doc2 ok");
            TransformerFactory transformerFactory2 = TransformerFactory.newInstance();
            Transformer transformer2 = transformerFactory2.newTransformer();
            DOMSource source2 = new DOMSource(doc2);
            StreamResult result2 = new StreamResult(file2);
            transformer2.transform(source2, result2);
            L.d("BackupThread:run:doc2 written");
            L.d("BackupThread:run:Dateien erzeugt");
            */
            Looper.prepare();
            Toast.makeText(context,"BackupThread:run:Backup created",Toast.LENGTH_SHORT).show();
        }
        catch (Exception e)
        {
            L.e("BackupThread:run:Exception:");
            L.e(e.toString());
        }
        L.d("BackupThread:run:beendet");
    }
}
