/*
 * Decompiled with CFR 0.152.
 */
package org.myoggradio.buforth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import androidx.appcompat.app.AppCompatActivity;
import java.time.LocalDate;
import org.myoggradio.buforth.BackupThread;
import org.myoggradio.buforth.ErfassenActivity;
import org.myoggradio.buforth.L;
import org.myoggradio.buforth.LetzteActivity;
import org.myoggradio.buforth.NaechsteActivity;
import org.myoggradio.buforth.NamenActivity;
import org.myoggradio.buforth.PapierkorbActivity;
import org.myoggradio.buforth.R;
import org.myoggradio.buforth.RestorePapierkorbActivity;
import org.myoggradio.buforth.RestoreTerminActivity;

public class MenuActivity
extends AppCompatActivity
implements View.OnClickListener {
    private Button uebersicht = null;
    private Button erfassen = null;
    private Button letzte = null;
    private Button papierkorb = null;
    private Button namen = null;
    private Button naechste = null;
    private Button backup = null;
    private Button restore_termin = null;
    private Button restore_papierkorb = null;
    private int ijahr = 0;
    private int imonat = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = this.getIntent();
            if (intent == null) {
                this.ijahr = LocalDate.now().getYear();
                this.imonat = LocalDate.now().getMonthValue();
            } else {
                String sjahr = intent.getStringExtra("jahr");
                String smonat = intent.getStringExtra("monat");
                if (sjahr == null) {
                    sjahr = "-1";
                }
                if (smonat == null) {
                    smonat = "-1";
                }
                this.ijahr = Integer.parseInt(sjahr);
                this.imonat = Integer.parseInt(smonat);
                if (this.ijahr < 0) {
                    this.ijahr = LocalDate.now().getYear();
                }
                if (this.imonat < 0) {
                    this.imonat = LocalDate.now().getMonthValue();
                }
            }
            this.setContentView(R.layout.activity_menu);
            this.uebersicht = (Button)this.findViewById(R.id.uebersicht);
            this.erfassen = (Button)this.findViewById(R.id.erfassen);
            this.letzte = (Button)this.findViewById(R.id.letzte);
            this.papierkorb = (Button)this.findViewById(R.id.papierkorb);
            this.namen = (Button)this.findViewById(R.id.namen);
            this.naechste = (Button)this.findViewById(R.id.naechste);
            this.backup = (Button)this.findViewById(R.id.backup);
            this.restore_termin = (Button)this.findViewById(R.id.restore_termin);
            this.restore_papierkorb = (Button)this.findViewById(R.id.restore_papierkorb);
            this.uebersicht.setOnClickListener((View.OnClickListener)this);
            this.erfassen.setOnClickListener((View.OnClickListener)this);
            this.letzte.setOnClickListener((View.OnClickListener)this);
            this.papierkorb.setOnClickListener((View.OnClickListener)this);
            this.namen.setOnClickListener((View.OnClickListener)this);
            this.naechste.setOnClickListener((View.OnClickListener)this);
            this.backup.setOnClickListener((View.OnClickListener)this);
            this.restore_termin.setOnClickListener((View.OnClickListener)this);
            this.restore_papierkorb.setOnClickListener((View.OnClickListener)this);
        }
        catch (Exception e) {
            L.e("MenuActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }

    public void onClick(View view) {
        Intent restoreIntent;
        if (view == this.uebersicht) {
            this.finish();
        }
        if (view == this.erfassen) {
            Intent erfassenIntent = new Intent((Context)this, ErfassenActivity.class);
            this.startActivity(erfassenIntent);
            this.finish();
        }
        if (view == this.letzte) {
            Intent letzteIntent = new Intent((Context)this, LetzteActivity.class);
            this.startActivity(letzteIntent);
            this.finish();
        }
        if (view == this.papierkorb) {
            Intent papierkorbIntent = new Intent((Context)this, PapierkorbActivity.class);
            this.startActivity(papierkorbIntent);
            this.finish();
        }
        if (view == this.naechste) {
            Intent naechsteIntent = new Intent((Context)this, NaechsteActivity.class);
            this.startActivity(naechsteIntent);
            this.finish();
        }
        if (view == this.namen) {
            Intent namenIntent = new Intent((Context)this, NamenActivity.class);
            this.startActivity(namenIntent);
            this.finish();
        }
        if (view == this.backup) {
            BackupThread thread = new BackupThread(this.getBaseContext());
            thread.start();
        }
        if (view == this.restore_termin) {
            restoreIntent = new Intent((Context)this, RestoreTerminActivity.class);
            this.startActivity(restoreIntent);
            this.finish();
        }
        if (view == this.restore_papierkorb) {
            restoreIntent = new Intent((Context)this, RestorePapierkorbActivity.class);
            this.startActivity(restoreIntent);
            this.finish();
        }
    }
}

