/*
 * Decompiled with CFR 0.152.
 */
package org.myoggradio.buforth;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.GridLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.time.LocalDate;
import org.myoggradio.buforth.DayButton;
import org.myoggradio.buforth.EinActivity;
import org.myoggradio.buforth.L;
import org.myoggradio.buforth.MenuActivity;
import org.myoggradio.buforth.MyDatabaseHelper;
import org.myoggradio.buforth.R;

public class MainActivity
extends AppCompatActivity
implements View.OnClickListener {
    private DayButton[][] butts = new DayButton[7][7];
    private GridLayout kalender = null;
    private TextView jahr = null;
    private TextView monat = null;
    private Button jahrplus = null;
    private Button jahrminus = null;
    private Button monatplus = null;
    private Button monatminus = null;
    private Button menu = null;
    private Button refresh = null;
    private int ijahr = 0;
    private int imonat = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = this.getIntent();
            if (intent == null) {
                this.ijahr = LocalDate.now().getYear();
                this.imonat = LocalDate.now().getMonthValue();
            } else {
                String sjahr = intent.getStringExtra("jahr");
                String smonat = intent.getStringExtra("monat");
                if (sjahr == null) {
                    sjahr = "-1";
                }
                if (smonat == null) {
                    smonat = "-1";
                }
                this.ijahr = Integer.parseInt(sjahr);
                this.imonat = Integer.parseInt(smonat);
                if (this.ijahr < 0) {
                    this.ijahr = LocalDate.now().getYear();
                }
                if (this.imonat < 0) {
                    this.imonat = LocalDate.now().getMonthValue();
                }
            }
            this.setContentView(R.layout.activity_main);
            this.kalender = (GridLayout)this.findViewById(R.id.kalender);
            this.jahr = (TextView)this.findViewById(R.id.jahr);
            this.monat = (TextView)this.findViewById(R.id.monat);
            this.jahrplus = (Button)this.findViewById(R.id.jahrplus);
            this.jahrminus = (Button)this.findViewById(R.id.jahrminus);
            this.monatplus = (Button)this.findViewById(R.id.monatplus);
            this.monatminus = (Button)this.findViewById(R.id.monatminus);
            this.menu = (Button)this.findViewById(R.id.menu);
            this.refresh = (Button)this.findViewById(R.id.refresh);
            this.jahrplus.setOnClickListener((View.OnClickListener)this);
            this.jahrminus.setOnClickListener((View.OnClickListener)this);
            this.monatplus.setOnClickListener((View.OnClickListener)this);
            this.monatminus.setOnClickListener((View.OnClickListener)this);
            this.menu.setOnClickListener((View.OnClickListener)this);
            this.jahr.setText((CharSequence)("" + this.ijahr));
            this.monat.setText((CharSequence)("" + this.imonat));
            this.refresh.setOnClickListener((View.OnClickListener)this);
            this.doRefresh();
        }
        catch (Exception e) {
            L.e("MainActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }

    public void doRefresh() {
        try {
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.butts[i][j] = this.getDayButton(i, j);
                    this.butts[i][j].setOnClickListener(this);
                    GridLayout.LayoutParams params = new GridLayout.LayoutParams();
                    params.rowSpec = GridLayout.spec((int)j);
                    params.columnSpec = GridLayout.spec((int)i);
                    params.width = 90;
                    this.butts[i][j].setLayoutParams((ViewGroup.LayoutParams)params);
                    this.kalender.addView((View)this.butts[i][j]);
                }
            }
        }
        catch (Exception e) {
            L.e("MainActivity:doRefresh:Exception:");
            L.e(e.toString());
        }
    }

    private DayButton getDayButton(int col, int row) {
        DayButton erg = new DayButton(this.getBaseContext());
        if (row == 0) {
            erg.setNumber(0);
            erg.setColor(-1);
            if (col == 0) {
                erg.setText("Mon");
            }
            if (col == 1) {
                erg.setText("Tue");
            }
            if (col == 2) {
                erg.setText("Wed");
            }
            if (col == 3) {
                erg.setText("Thu");
            }
            if (col == 4) {
                erg.setText("Fri");
            }
            if (col == 5) {
                erg.setText("Sat");
            }
            if (col == 6) {
                erg.setText("Sun");
            }
        } else {
            int pos;
            --row;
            LocalDate erster = LocalDate.of(this.ijahr, this.imonat, 1);
            int offset = erster.getDayOfWeek().getValue();
            if (offset == 0) {
                offset = 7;
            }
            if ((pos = 7 * row + col - --offset) < 0 | pos > 30) {
                erg.setNumber(0);
                erg.setText("");
                erg.setColor(-1);
            } else {
                erg.setNumber(pos + 1);
                int argb = this.getButtonColor(this.ijahr, this.imonat, pos + 1);
                erg.setColor(argb);
            }
            if (this.notExists(this.ijahr, this.imonat, pos + 1)) {
                erg.setNumber(0);
                erg.setText("");
                erg.setColor(-1);
            }
        }
        return erg;
    }

    public boolean notExists(int jahr, int monat, int tag) {
        boolean erg = false;
        try {
            LocalDate localDate = LocalDate.of(jahr, monat, tag);
        }
        catch (Exception e) {
            erg = true;
        }
        return erg;
    }

    public int getButtonColor(int jahr, int monat, int tag) {
        int erg = -1;
        try {
            MyDatabaseHelper helper = new MyDatabaseHelper((Context)this);
            SQLiteDatabase db = helper.getReadableDatabase();
            String sql = "select count(*) from termin where jahr = ? and monat = ? and tag = ?";
            Cursor dbCursor = db.rawQuery(sql, new String[]{"" + jahr, "" + monat, "" + tag});
            int anzahl = 0;
            while (dbCursor.moveToNext()) {
                anzahl = dbCursor.getInt(0);
            }
            dbCursor.close();
            db.close();
            erg = anzahl == 0 ? -1 : (anzahl == 1 ? -16711936 : (anzahl == 2 | anzahl == 3 ? -256 : -65536));
        }
        catch (Exception e) {
            L.e("MainActivity:getButtonColor:Exception:");
            L.e(e.toString());
        }
        return erg;
    }

    public void onClick(View view) {
        Intent mainIntent;
        if (view == this.refresh) {
            this.doRefresh();
        }
        if (view == this.menu) {
            Intent menuIntent = new Intent((Context)this, MenuActivity.class);
            menuIntent.putExtra("jahr", "" + this.ijahr);
            menuIntent.putExtra("monat", "" + this.imonat);
            this.startActivity(menuIntent);
        }
        if (view == this.jahrplus) {
            mainIntent = new Intent((Context)this, MainActivity.class);
            mainIntent.putExtra("jahr", "" + (this.ijahr + 1));
            mainIntent.putExtra("monat", "" + this.imonat);
            this.startActivity(mainIntent);
            this.finish();
        }
        if (view == this.jahrminus) {
            mainIntent = new Intent((Context)this, MainActivity.class);
            mainIntent.putExtra("jahr", "" + (this.ijahr - 1));
            mainIntent.putExtra("monat", "" + this.imonat);
            this.startActivity(mainIntent);
            this.finish();
        }
        if (view == this.monatplus) {
            ++this.imonat;
            if (this.imonat > 12) {
                this.imonat = 1;
                ++this.ijahr;
            }
            mainIntent = new Intent((Context)this, MainActivity.class);
            mainIntent.putExtra("jahr", "" + this.ijahr);
            mainIntent.putExtra("monat", "" + this.imonat);
            this.startActivity(mainIntent);
            this.finish();
        }
        if (view == this.monatminus) {
            --this.imonat;
            if (this.imonat < 1) {
                this.imonat = 12;
                --this.ijahr;
            }
            mainIntent = new Intent((Context)this, MainActivity.class);
            mainIntent.putExtra("jahr", "" + this.ijahr);
            mainIntent.putExtra("monat", "" + this.imonat);
            this.startActivity(mainIntent);
            this.finish();
        }
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int itag;
                if (view != this.butts[i][j] || (itag = this.butts[i][j].getNumber()) == 0) continue;
                L.d("" + this.butts[i][j].getNumber());
                Intent einIntent = new Intent((Context)this, EinActivity.class);
                einIntent.putExtra("jahr", "" + this.ijahr);
                einIntent.putExtra("monat", "" + this.imonat);
                einIntent.putExtra("tag", "" + itag);
                this.startActivity(einIntent);
            }
        }
    }
}

