/*
 * Decompiled with CFR 0.152.
 */
package org.myoggradio.buforth;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;
import org.myoggradio.buforth.MyDatabaseHelper;
import org.myoggradio.buforth.R;
import org.myoggradio.buforth.SatzTermin;
import org.myoggradio.buforth.Util;

public class DetailActivity
extends AppCompatActivity
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private String[] text = null;
    private ArrayList<SatzTermin> temp = null;
    private int position = -1;
    ArrayAdapter<String> arrayAdapter = null;
    String beschreibung = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.beschreibung = intent.getStringExtra("beschreibung");
        this.setContentView(R.layout.activity_detail);
        this.ueberschrift = (TextView)this.findViewById(R.id.ueberschrift_detail);
        MyDatabaseHelper helper = new MyDatabaseHelper((Context)this);
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select id,jahr,monat,tag,stunde,minute,beschreibung from termin where beschreibung = ? order by jahr,monat,tag,stunde,minute,id";
        Cursor dbCursor = db.rawQuery(sql, new String[]{this.beschreibung});
        this.temp = new ArrayList();
        while (dbCursor.moveToNext()) {
            long id2 = dbCursor.getLong(0);
            int jahr = dbCursor.getInt(1);
            int monat = dbCursor.getInt(2);
            int tag = dbCursor.getInt(3);
            int stunde = dbCursor.getInt(4);
            int minute = dbCursor.getInt(5);
            String beschreibung = dbCursor.getString(6);
            SatzTermin satz = new SatzTermin();
            satz.setId(id2);
            satz.setJahr(jahr);
            satz.setMonat(monat);
            satz.setTag(tag);
            satz.setStunde(stunde);
            satz.setMinute(minute);
            satz.setBeschreibung(beschreibung);
            this.temp.add(satz);
        }
        db.close();
        Log.d((String)"MyOggRadioTag", (String)"Database kompleted");
        String s = "All Appointments with same Description";
        if (this.temp.size() == 0) {
            s = s + " No Appointments";
        }
        this.ueberschrift.setText((CharSequence)s);
        this.text = new String[2 * this.temp.size()];
        for (int i = 0; i < this.temp.size(); ++i) {
            SatzTermin termin = this.temp.get(i);
            String x = Util.formatInteger(termin.getTag(), 2) + "." + Util.formatInteger(termin.getMonat(), 2) + "." + Util.formatInteger(termin.getJahr(), 4);
            this.text[2 * i] = x = x + " " + Util.formatInteger(termin.getStunde(), 2) + ":" + Util.formatInteger(termin.getMinute(), 2);
            this.text[2 * i + 1] = " " + termin.getBeschreibung();
        }
        this.l_view = (ListView)this.findViewById(R.id.list_detail);
        this.arrayAdapter = new ArrayAdapter((Context)this, R.layout.row, (Object[])this.text);
        this.l_view.setAdapter(this.arrayAdapter);
        this.l_view.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        Log.d((String)"MyOggRadioTag", (String)"Adapter set");
    }

    public void onClick(View view) {
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
        this.position = i / 2;
    }
}

