/*
 * Decompiled with CFR 0.152.
 */
package org.myoggradio.buforth;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Looper;
import android.widget.Toast;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.myoggradio.buforth.L;
import org.myoggradio.buforth.MyDatabaseHelper;
import org.myoggradio.buforth.SatzTermin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RestoreTerminThread
extends Thread {
    private ArrayList<SatzTermin> termine = new ArrayList();
    private Context context = null;
    private Uri name = null;

    public RestoreTerminThread(Context context, Uri name) {
        this.context = context;
        this.name = name;
    }

    @Override
    public void run() {
        L.d("RestoreTerminThread:run:gestarted");
        try {
            InputStream file = this.context.getContentResolver().openInputStream(this.name);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            this.explore(root);
            MyDatabaseHelper helper = new MyDatabaseHelper(this.context);
            SQLiteDatabase db = helper.getWritableDatabase();
            db.delete("termin", null, null);
            for (int i = 0; i < this.termine.size(); ++i) {
                SatzTermin satz = this.termine.get(i);
                long id2 = satz.getId();
                int jahr = satz.getJahr();
                int monat = satz.getMonat();
                int tag = satz.getTag();
                int stunde = satz.getStunde();
                int minute = satz.getMinute();
                String beschreibung = satz.getBeschreibung().trim();
                boolean urlaub = false;
                ContentValues values = new ContentValues();
                values.put("id", Long.valueOf(id2));
                values.put("jahr", Integer.valueOf(jahr));
                values.put("monat", Integer.valueOf(monat));
                values.put("tag", Integer.valueOf(tag));
                values.put("stunde", Integer.valueOf(stunde));
                values.put("minute", Integer.valueOf(minute));
                values.put("beschreibung", beschreibung);
                values.put("urlaub", Integer.valueOf(0));
                db.insert("termin", null, values);
            }
            db.close();
            Looper.prepare();
            Toast.makeText((Context)this.context, (CharSequence)"RestoreTerminThread:run:restored", (int)0).show();
        }
        catch (Exception e) {
            L.e("RestoreTerminThread:run:Exception:");
            L.e(e.toString());
        }
        L.d("RestoreTerminThread:run:beendet");
    }

    public void explore(Element element) {
        long id2 = 0L;
        int jahr = 0;
        int monat = 0;
        int tag = 0;
        int stunde = 0;
        int minute = 0;
        String beschreibung = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element nextElement = (Element)node;
            String elementName = node.getNodeName();
            if (elementName.equals("id")) {
                id2 = Long.parseLong(nextElement.getAttribute("value"));
            }
            if (elementName.equals("jahr")) {
                jahr = Integer.parseInt(nextElement.getAttribute("value"));
            }
            if (elementName.equals("monat")) {
                monat = Integer.parseInt(nextElement.getAttribute("value"));
            }
            if (elementName.equals("tag")) {
                tag = Integer.parseInt(nextElement.getAttribute("value"));
            }
            if (elementName.equals("stunde")) {
                stunde = Integer.parseInt(nextElement.getAttribute("value"));
            }
            if (elementName.equals("minute")) {
                minute = Integer.parseInt(nextElement.getAttribute("value"));
            }
            if (elementName.equals("beschreibung")) {
                beschreibung = nextElement.getTextContent().trim();
                SatzTermin satz = new SatzTermin();
                satz.setId(id2);
                satz.setJahr(jahr);
                satz.setMonat(monat);
                satz.setTag(tag);
                satz.setStunde(stunde);
                satz.setMinute(minute);
                satz.setBeschreibung(beschreibung);
                this.termine.add(satz);
            }
            this.explore(nextElement);
        }
    }
}

