/*
 * Decompiled with CFR 0.152.
 */
package org.myoggradio.buforth;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;
import org.myoggradio.buforth.DetailActivity;
import org.myoggradio.buforth.MyDatabaseHelper;
import org.myoggradio.buforth.R;
import org.myoggradio.buforth.SatzTermin;
import org.myoggradio.buforth.Util;

public class NamenActivity
extends AppCompatActivity
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private Button details = null;
    private String[] text = null;
    private ArrayList<SatzTermin> temp = null;
    private int position = -1;
    private View position_view = null;
    ArrayAdapter<String> arrayAdapter = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_namen);
        this.ueberschrift = (TextView)this.findViewById(R.id.ueberschrift_namen);
        this.details = (Button)this.findViewById(R.id.details);
        this.details.setOnClickListener((View.OnClickListener)this);
        MyDatabaseHelper helper = new MyDatabaseHelper((Context)this);
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select beschreibung,count(*) from termin group by beschreibung order by beschreibung";
        Cursor dbCursor = db.rawQuery(sql, null);
        this.temp = new ArrayList();
        while (dbCursor.moveToNext()) {
            String beschreibung = dbCursor.getString(0);
            int anzahl = dbCursor.getInt(1);
            SatzTermin satz = new SatzTermin();
            satz.setJahr(anzahl);
            satz.setBeschreibung(beschreibung);
            this.temp.add(satz);
        }
        db.close();
        Log.d((String)"MyOggRadioTag", (String)"Database kompleted");
        String s = "Group by Description";
        if (this.temp.size() == 0) {
            s = s + " No Appointments";
        }
        this.ueberschrift.setText((CharSequence)s);
        this.text = new String[this.temp.size()];
        for (int i = 0; i < this.temp.size(); ++i) {
            String x;
            SatzTermin termin = this.temp.get(i);
            this.text[i] = x = Util.formatInteger(termin.getJahr(), 4) + " " + termin.getBeschreibung();
        }
        this.l_view = (ListView)this.findViewById(R.id.list_namen);
        this.arrayAdapter = new ArrayAdapter((Context)this, R.layout.row, (Object[])this.text);
        this.l_view.setAdapter(this.arrayAdapter);
        this.l_view.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        Log.d((String)"MyOggRadioTag", (String)"Adapter set");
    }

    public void onClick(View view) {
        if (view == this.details && this.position >= 0) {
            SatzTermin termin = this.temp.get(this.position);
            String name = termin.getBeschreibung();
            MyDatabaseHelper helper = new MyDatabaseHelper((Context)this);
            Intent detailIntent = new Intent((Context)this, DetailActivity.class);
            detailIntent.putExtra("beschreibung", name);
            this.startActivity(detailIntent);
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
        if (this.position_view != null) {
            this.position_view.setBackgroundColor(-16711936);
        }
        this.position_view = view;
        view.setBackgroundColor(-65536);
        this.position = i;
    }
}

