/*
 * Decompiled with CFR 0.152.
 */
package org.myoggradio.buforth;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Looper;
import android.widget.Toast;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.myoggradio.buforth.L;
import org.myoggradio.buforth.MyDatabaseHelper;
import org.myoggradio.buforth.SatzTermin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class BackupThread
extends Thread {
    private Context context = null;
    private Uri uri = null;

    public BackupThread(Context context, Uri uri) {
        this.uri = uri;
        this.context = context;
    }

    @Override
    public void run() {
        L.d("BackupThread:run:gestarted");
        try {
            String pattern = "yyyy_MM_dd_HH_mm_ss";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            String prefix = LocalDateTime.now().format(formatter);
            OutputStream file = this.context.getContentResolver().openOutputStream(this.uri);
            MyDatabaseHelper helper = new MyDatabaseHelper(this.context);
            SQLiteDatabase db = helper.getReadableDatabase();
            String sql = "select id,jahr,monat,tag,stunde,minute,beschreibung from termin";
            Cursor dbCursor = db.rawQuery(sql, null);
            ArrayList<SatzTermin> termine = new ArrayList<SatzTermin>();
            while (dbCursor.moveToNext()) {
                long id2 = dbCursor.getLong(0);
                int jahr = dbCursor.getInt(1);
                int monat = dbCursor.getInt(2);
                int tag = dbCursor.getInt(3);
                int stunde = dbCursor.getInt(4);
                int minute = dbCursor.getInt(5);
                String beschreibung = dbCursor.getString(6);
                SatzTermin satz = new SatzTermin();
                satz.setId(id2);
                satz.setJahr(jahr);
                satz.setMonat(monat);
                satz.setTag(tag);
                satz.setStunde(stunde);
                satz.setMinute(minute);
                satz.setBeschreibung(beschreibung);
                termine.add(satz);
            }
            L.d("BackupThread:run:Database ok");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docb = dbf.newDocumentBuilder();
            Document doc = docb.newDocument();
            Element root = doc.createElement("BackupTermin");
            doc.appendChild(root);
            for (int i = 0; i < termine.size(); ++i) {
                SatzTermin satz = (SatzTermin)termine.get(i);
                Element termin = doc.createElement("Termin");
                long id3 = satz.getId();
                Element eid = doc.createElement("id");
                eid.setAttribute("value", id3 + "");
                termin.appendChild(eid);
                int jahr = satz.getJahr();
                Element ejahr = doc.createElement("jahr");
                ejahr.setAttribute("value", jahr + "");
                termin.appendChild(ejahr);
                int monat = satz.getMonat();
                Element emonat = doc.createElement("monat");
                emonat.setAttribute("value", monat + "");
                termin.appendChild(emonat);
                int tag = satz.getTag();
                Element etag = doc.createElement("tag");
                etag.setAttribute("value", tag + "");
                termin.appendChild(etag);
                int stunde = satz.getStunde();
                Element estunde = doc.createElement("stunde");
                estunde.setAttribute("value", stunde + "");
                termin.appendChild(estunde);
                int minute = satz.getMinute();
                Element eminute = doc.createElement("minute");
                eminute.setAttribute("value", minute + "");
                termin.appendChild(eminute);
                String beschreibung = satz.getBeschreibung();
                Element ebeschreibung = doc.createElement("beschreibung");
                Text text = doc.createTextNode(beschreibung.trim());
                ebeschreibung.appendChild(text);
                termin.appendChild(ebeschreibung);
                root.appendChild(termin);
            }
            L.d("BackupThread:run:doc ok");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
            L.d("BackupThread:run:doc written");
            Looper.prepare();
            Toast.makeText((Context)this.context, (CharSequence)"BackupThread:run:Backup created", (int)0).show();
        }
        catch (Exception e) {
            L.e("BackupThread:run:Exception:");
            L.e(e.toString());
        }
        L.d("BackupThread:run:beendet");
    }
}

