package eu.myoggradio.barcodescannercompare;

import android.content.Context;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.view.Surface;
import android.view.SurfaceView;

import androidx.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class MyStateCallback  extends CameraDevice.StateCallback {
    private SurfaceView surface = null;
    private Executor executor = null;
    public MyStateCallback(SurfaceView surface,Executor executor)
    {
        this.surface = surface;
        this.executor = executor;
    }
    @Override
    public void onOpened(@NonNull CameraDevice camera)
    {
        L.d("MainActivity:onOpened");
        try {
            OutputConfiguration outout = new OutputConfiguration(new Surface(surface.getSurfaceControl()));
            List<OutputConfiguration> list = new ArrayList<OutputConfiguration>();
            MyCameraCaptureSessionCallback callback = new MyCameraCaptureSessionCallback();
            SessionConfiguration cfg = new SessionConfiguration(SessionConfiguration.SESSION_REGULAR,list,executor,callback);
            camera.createCaptureSession(cfg);
        }
        catch (Exception e)
        {
            L.e("MainActivity:onOpened:Exception:");
            L.e(e.toString());
        }
    }
    @Override
    public void onDisconnected(@NonNull CameraDevice camera)
    {
        L.d("MainActivity:onDisconnected");
    }
    @Override
    public void onError(@NonNull CameraDevice camera, int error)
    {
        L.d("MainActivity:onError");
    }
}
