package eu.myoggradio.barcodescannercompare;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;

public class MenuActivity extends AppCompatActivity implements View.OnClickListener
{
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private Button list1 = null;
    private Button list2 = null;
    private Button show1 = null;
    private Button show2 = null;
    private Button reset1 = null;
    private Button reset2 = null;
    private Button drop1 = null;
    private Button drop2 = null;
    private Button camera = null;
    private Button compare = null;
    private String[] text = null;
    private ArrayList<String> temp = new ArrayList<String>();
    ArrayAdapter<String> arrayAdapter = null;
    String serial = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = getIntent();
            serial = intent.getStringExtra("barcodes");
            temp = BarcodeUtilRAM.deserialize(serial);
            setContentView(R.layout.activity_menu);
            ueberschrift = (TextView) findViewById(R.id.ueberschrift);
            list1 = (Button) findViewById(R.id.list1);
            list2 = (Button) findViewById(R.id.list2);
            show1 = (Button) findViewById(R.id.show1);
            show2 = (Button) findViewById(R.id.show2);
            reset1 = (Button) findViewById(R.id.reset1);
            reset2 = (Button) findViewById(R.id.reset2);
            drop1 = (Button) findViewById(R.id.drop1);
            drop2 = (Button) findViewById(R.id.drop2);
            camera = (Button) findViewById(R.id.camera);
            compare = (Button) findViewById(R.id.compare);
            list1.setOnClickListener(this);
            list2.setOnClickListener(this);
            show1.setOnClickListener(this);
            show2.setOnClickListener(this);
            reset1.setOnClickListener(this);
            reset2.setOnClickListener(this);
            drop1.setOnClickListener(this);
            drop2.setOnClickListener(this);
            camera.setOnClickListener(this);
            compare.setOnClickListener(this);
            ueberschrift.setText("Menu");
            text = new String[temp.size()];
            for (int i = 0; i < temp.size(); i++) {
                String code = BarcodeUtilRAM.formatInteger(i+1,3) + ":" + temp.get(i);
                text[i] = code;
            }
            ;
            l_view = (ListView) findViewById(R.id.list);
            arrayAdapter = new ArrayAdapter<String>(this, R.layout.row, text);
            l_view.setAdapter(arrayAdapter);
        }
        catch (Exception e)
        {
            L.e("MenuActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }

    @Override
    public void onClick(View view)
    {
        if (view == show1)
        {
            ArrayList<String> list = BarcodeUtilRAM.getList1();
            String slist = BarcodeUtilRAM.serialize(list);
            Intent listIntent = new Intent(this, ListActivity.class);
            listIntent.putExtra("liste",slist);
            startActivity(listIntent);
        }
        if (view == show2)
        {
            ArrayList<String> list = BarcodeUtilRAM.getList2();
            String slist = BarcodeUtilRAM.serialize(list);
            Intent listIntent = new Intent(this, ListActivity.class);
            listIntent.putExtra("liste",slist);
            startActivity(listIntent);
        }
        if (view == reset1)
        {
            BarcodeUtilRAM.resetList1();
            Toast.makeText(this.getBaseContext(),"MenuActivity:onClick:reset1:List1 resetted",Toast.LENGTH_SHORT).show();
        }
        if (view == reset2)
        {
            BarcodeUtilRAM.resetList2();
            Toast.makeText(this.getBaseContext(),"MenuActivity:onClick:reset2:List2 resetted",Toast.LENGTH_SHORT).show();
        }
        if (view == drop1)
        {
            BarcodeUtilRAM.dropFromList1(temp);
            Toast.makeText(this.getBaseContext(),"MenuActivity:onClick:drop1:Dropped from List1",Toast.LENGTH_SHORT).show();
         }
        if (view == drop2)
        {
            BarcodeUtilRAM.dropFromList2(temp);
            Toast.makeText(this.getBaseContext(),"MenuActivity:onClick:drop2:Dropped from List2",Toast.LENGTH_SHORT).show();
        }
        if (view == list1)
        {
            BarcodeUtilRAM.addToList1(temp);
            Intent menuIntent = new Intent(this, MainActivity.class);
            startActivity(menuIntent);
        }
        if (view == list2)
        {
            BarcodeUtilRAM.addToList2(temp);
            Intent menuIntent = new Intent(this, MainActivity.class);
            startActivity(menuIntent);
        }
        if (view == camera)
        {
            Intent menuIntent = new Intent(this, MainActivity.class);
            startActivity(menuIntent);
            finish();
        }
        if (view == compare)
        {
            Intent compareIntent = new Intent(this, CompareActivity.class);
            startActivity(compareIntent);
            //finish();
        }
    }
}