package eu.myoggradio.barcodescannercompare;
import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.view.View;
import android.widget.Button;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.Preview;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.video.Recorder;
import androidx.camera.video.VideoCapture;
import androidx.camera.view.PreviewView;
import androidx.core.app.ActivityCompat;

import com.google.android.gms.tasks.OnSuccessListener;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {
    private static boolean looperPrepared = false;
    private PreviewView surface = null;
    private Button scan = null;
    private ListenableFuture<ProcessCameraProvider> provider = null;
    private ImageCapture imageCapture = null;
    private VideoCapture videoCapture = null;
    private ProcessCameraProvider cameraProvider = null;
    private Context context = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        context = this.getBaseContext();
        BarcodeUtil.init(context); // Nur fuer SQL
        setContentView(R.layout.activity_main);
        try {
            if (!looperPrepared)
            {
                looperPrepared = true;
                Looper.prepare();
            }
        }
        catch (Exception e)
        {
            L.e("MenuActivity:onCreate:Exception1_");
            L.e(e.toString());
        }
        scan = (Button) findViewById(R.id.scan);
        surface = (PreviewView) findViewById(R.id.camera_view);
        //
        if (ActivityCompat.checkSelfPermission(this, android.Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED)
        {
            ActivityCompat.requestPermissions(this,new String[]{Manifest.permission.CAMERA},100);
        }
        //
        surface.setOnClickListener(this);
        try {
            provider = ProcessCameraProvider.getInstance(this);
            provider.addListener(() -> {
                try {
                    ProcessCameraProvider cameraProvider = provider.get();
                    this.cameraProvider = cameraProvider;
                    startCameraX(cameraProvider);
                } catch (Exception e) {
                    L.e("MainActivity:onCreate:Exception:");
                    L.e(e.toString());
                }
            }, getExecutor());
        }
        catch (Exception e)
        {
            L.e("MainActivity:onCreate:Exception:");
            L.e(e.toString());
        }
        scan.setOnClickListener(this);
    }

    private void startCameraX(ProcessCameraProvider cameraProvider) {
        try {
            cameraProvider.unbindAll();
            ;
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(CameraSelector.LENS_FACING_BACK).build();
            Preview preview = new Preview.Builder().build();
            preview.setSurfaceProvider(surface.getSurfaceProvider());
            imageCapture = new ImageCapture.Builder().setCaptureMode(ImageCapture.CAPTURE_MODE_MINIMIZE_LATENCY).build();
            Recorder recorder = new Recorder.Builder().build();
            videoCapture = new VideoCapture.Builder(recorder).build();
            cameraProvider.bindToLifecycle(this, cameraSelector, preview, imageCapture, videoCapture);
        }
        catch (Exception e)
        {
            L.e("MainActivity:startCamera:Exception:");
            L.e(e.toString());
        }
    }

    private Executor getExecutor() {
        return this.getMainExecutor();
    }

    @Override
    public void onClick(View v) {
        if (v == scan)
        {

        }
        if (v == surface)
        {
            L.d("MainActivity:onClick:surface");
            File file = new File(Environment.getExternalStorageDirectory().toString(), "/Download/barcodescannercompare.png");
            ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(file).build();
            imageCapture.takePicture(outputFileOptions, getExecutor(), new ImageCapture.OnImageSavedCallback() {
                        @Override
                        public void onImageSaved(ImageCapture.OutputFileResults outputFileResults) {
                            L.d("MainActivity:onClick:surface:Image saved");
                            try {
                                cameraProvider.unbindAll();
                                InputImage image = InputImage.fromFilePath(context, Uri.fromFile(file));
                                BarcodeScanner scanner = BarcodeScanning.getClient();
                                scanner.process(image).addOnSuccessListener(new OnSuccessListener<List<Barcode>>()
                                                                            {
                                                                                @Override
                                                                                public void onSuccess(List<Barcode> barcodes)
                                                                                {
                                                                                    ArrayList<String> codes = new ArrayList<String>();
                                                                                    for (Barcode barcode : barcodes)
                                                                                    {
                                                                                        String rawValue = barcode.getRawValue();
                                                                                        codes.add(rawValue);
                                                                                        L.d("MainActivity:onClick:surface:rawValue:" + rawValue);
                                                                                    }
                                                                                    L.d("MainActivity:onClick:surface:Anzahl Barcodes:"+codes.size());
                                                                                    try {
                                                                                        String serial = BarcodeUtilRAM.serialize(codes);
                                                                                        Intent menuIntent = new Intent(context, MenuActivity.class);
                                                                                        menuIntent.putExtra("barcodes", serial);
                                                                                        startActivity(menuIntent);
                                                                                        finish();
                                                                                    }
                                                                                    catch (Exception e)
                                                                                    {
                                                                                        L.e("MainActivity:onClick:surface:onImageSaved:Exception:");
                                                                                        L.e(e.toString());
                                                                                    }
                                                                                }
                                                                            }
                                );
                            }
                            catch (Exception e)
                            {
                                L.e("MainActivity:onClick:surface:Exception:");
                                L.e(e.toString());
                            }
                        }
                        @Override
                        public void onError(ImageCaptureException error) {
                            L.e("MainActivity:onClick:surface:Error:");
                            L.e(error.toString());
                        }
                    }
            );
        }
    }
}