package eu.myoggradio.barcodescannercompare;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.ArrayList;

public class ListActivity extends AppCompatActivity implements View.OnClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private String[] text = null;
    private ArrayList<String> temp = null;
    ArrayAdapter<String> arrayAdapter = null;
    String serial = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = getIntent();
            serial = intent.getStringExtra("liste");
            temp = BarcodeUtilRAM.deserialize(serial);
            setContentView(R.layout.activity_list);
            ueberschrift = (TextView) findViewById(R.id.list_ueberschrift);
            ueberschrift.setText("Barcode Liste");
            text = new String[temp.size()];
            for (int i = 0; i < temp.size(); i++) {
                String code = BarcodeUtilRAM.formatInteger(i+1,3) + ":" + temp.get(i);
                text[i] = code;
            }
            l_view = (ListView) findViewById(R.id.list_list);
            arrayAdapter = new ArrayAdapter<String>(this, R.layout.row, text);
            l_view.setAdapter(arrayAdapter);
        } catch (Exception e) {
            L.e("ListActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }

    @Override
    public void onClick(View view) {

    }
}