package eu.myoggradio.barcodescannercompare;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;

import java.util.ArrayList;

public class CompareActivity extends AppCompatActivity implements View.OnClickListener {
    private ListView l_view = null;
    private TextView ueberschrift = null;
    private String[] text = null;
    private ArrayList<String> temp = null;
    ArrayAdapter<String> arrayAdapter = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent intent = getIntent();
            ArrayList<String> list1 = BarcodeUtilRAM.fromList1NotInList2();
            ArrayList<String> list2 = BarcodeUtilRAM.fromList2NotInList1();
            setContentView(R.layout.activity_compare);
            ueberschrift = (TextView) findViewById(R.id.compare_ueberschrift);
            ueberschrift.setText("Barcode Listen Compare");
            text = new String[list1.size() + list2.size()];
            for (int i = 0; i < list1.size(); i++) {
                String code = "1:" + BarcodeUtilRAM.formatInteger(i+1,3) + ":" + list1.get(i);
                text[i] = code;
            }
            for (int i = 0; i < list2.size(); i++) {
                String code = "2:" + BarcodeUtilRAM.formatInteger(i+1,3) + ":" + list2.get(i);
                text[i+list1.size()] = code;
            }
            l_view = (ListView) findViewById(R.id.compare_list);
            arrayAdapter = new ArrayAdapter<String>(this, R.layout.row, text);
            l_view.setAdapter(arrayAdapter);
        } catch (Exception e) {
            L.e("ListActivity:onCreate:Exception:");
            L.e(e.toString());
        }
    }

    @Override
    public void onClick(View view) {

    }
}