package eu.myoggradio.barcodescannercompare;

import java.util.ArrayList;
import java.util.Collections;

public class BarcodeUtilRAM
{
    private static ArrayList<String> barcodeList1 = new ArrayList<String>();
    private static ArrayList<String> barcodeList2 = new ArrayList<String>();
    public static String formatInteger(int i,int stellen)
    {
        String erg = "" + i;
        int len = erg.length();
        for (int x=len;x<stellen;x++)
        {
            erg = "0" + erg;
        }
        return erg;
    }
    public static void resetList1()
    {
        barcodeList1 = new ArrayList<String>();
    }
    public static void resetList2()
    {
        barcodeList2 = new ArrayList<String>();
    }
    public static ArrayList<String> getList1()
    {
        return barcodeList1;
    }
    public static ArrayList<String> getList2()
    {
        return barcodeList2;
    }
    public static void addToList1(ArrayList<String> barcodeList)
    {
        for (int i=0;i<barcodeList.size();i++)
        {
            String code = barcodeList.get(i).trim();
            boolean bereitsInList = false;
            if (code.length() == 0) bereitsInList = true;
            /* Prüfung auf Doppelte entfällt
            for (int j=0;j<barcodeList1.size();j++)
            {
                String test = barcodeList1.get(j).trim();
                if (test.equals(code)) bereitsInList = true;
            }
            */
            if (!bereitsInList) barcodeList1.add(code);
        }
        Collections.sort(barcodeList1);
    }
    public static void addToList2(ArrayList<String> barcodeList)
    {
        for (int i=0;i<barcodeList.size();i++)
        {
            String code = barcodeList.get(i).trim();
            boolean bereitsInList = false;
            if (code.length() == 0) bereitsInList = true;
            /* Prüfung auf Doppelte entfällt
            for (int j=0;j<barcodeList2.size();j++)
            {
                String test = barcodeList2.get(j).trim();
                if (test.equals(code)) bereitsInList = true;
            }
            */
            if (!bereitsInList) barcodeList2.add(code);
        }
        Collections.sort(barcodeList2);
    }
    public static String serialize(ArrayList<String> al)
    {
        String erg = "";
        for (int i=0;i<al.size();i++)
        {
            if (i<al.size()-1) {
                erg += al.get(i) + "#";
            }
            else
            {
                erg += al.get(i);
            }
        }
        return erg;
    }
    public static ArrayList<String> deserialize(String s)
    {
        ArrayList<String> erg = new ArrayList<String>();
        String[] codes = s.split("#");
        for (int i=0;i<codes.length;i++)
        {
            String code = codes[i].trim();
            if (code.length() > 0) {
                erg.add(code);
            }
        }
        return erg;
    }
    public static ArrayList<String> fromList1NotInList2()
    {
        ArrayList<String> erg = new ArrayList<String>();
        ArrayList<String> copy = new ArrayList<String>();
        for (int i=0;i<barcodeList2.size();i++)
        {
            copy.add(barcodeList2.get(i));
        }
        for (int i=0;i<barcodeList1.size();i++) {
            int positionGefunden = -1;
            String test = barcodeList1.get(i);
            for (int j = 0; j < copy.size(); j++) {
                String code = copy.get(j);
                if (test.equals(code)) {
                    positionGefunden = j;
                }
            }
            if (positionGefunden == -1) {
                erg.add(test);
            } else {
                ArrayList<String> temp = new ArrayList<String>();
                for (int j = 0; j < copy.size(); j++) {
                    if (j != positionGefunden) temp.add(copy.get(j));
                }
                copy = temp;
            }
        }
        return erg;
    }
    public static ArrayList<String> fromList2NotInList1()
    {
        ArrayList<String> erg = new ArrayList<String>();
        ArrayList<String> copy = new ArrayList<String>();
        for (int i=0;i<barcodeList1.size();i++)
        {
            copy.add(barcodeList1.get(i));
        }
        for (int i=0;i<barcodeList2.size();i++) {
            int positionGefunden = -1;
            String test = barcodeList2.get(i);
            for (int j = 0; j < copy.size(); j++) {
                String code = copy.get(j);
                if (test.equals(code)) {
                    positionGefunden = j;
                }
            }
            if (positionGefunden == -1) {
                erg.add(test);
            } else {
                ArrayList<String> temp = new ArrayList<String>();
                for (int j = 0; j < copy.size(); j++) {
                    if (j != positionGefunden) temp.add(copy.get(j));
                }
                copy = temp;
            }
        }
        return erg;
    }
    public static void dropFromList1(ArrayList<String> al)
    {
        L.d("BarcodeUtil:dropFromList1:gestarted");
        for (int i=0;i<al.size();i++)
        {
            int positionGefunden = -1;
            String test = al.get(i).trim();
            for (int j=0;j<barcodeList1.size();j++)
            {
                String code = barcodeList1.get(j).trim();
                if (test.equals(code))
                {
                    positionGefunden = j;
                }
            }
            L.d("BarcodeUtil:dropFromList1:positionGefunden:" + positionGefunden);
            if (positionGefunden != -1)
            {
                L.d("BarcodeUtil:dropFromList1:positionGefunden:" + positionGefunden);
                ArrayList<String> temp = new ArrayList<String>();
                for (int j=0;j<barcodeList1.size();j++)
                {
                    if (j != positionGefunden) temp.add(barcodeList1.get(j));
                }
                barcodeList1 = temp;
            }
        }
    }
    public static void dropFromList2(ArrayList<String> al)
    {
        for (int i=0;i<al.size();i++)
        {
            int positionGefunden = -1;
            String test = al.get(i).trim();
            for (int j=0;j<barcodeList2.size();j++)
            {
                String code = barcodeList2.get(j).trim();
                if (test.equals(code))
                {
                    positionGefunden = j;
                }
            }
            if (positionGefunden != -1)
            {
                ArrayList<String> temp = new ArrayList<String>();
                for (int j=0;j<barcodeList2.size();j++)
                {
                    if (j != positionGefunden) temp.add(barcodeList1.get(j));
                }
                barcodeList2 = temp;
            }
        }
    }
}
