package eu.myoggradio.barcodescannercompare;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import java.util.ArrayList;
import java.util.Date;

public class BarcodeUtil
{
    private static MyDatabaseHelper helper = null;
    private static ArrayList<String> barcodeList1 = new ArrayList<String>();
    private static ArrayList<String> barcodeList2 = new ArrayList<String>();
    public static void init(Context context)
    {
        helper = new MyDatabaseHelper(context);
    }
    public static String formatInteger(int i,int stellen)
    {
        String erg = "" + i;
        int len = erg.length();
        for (int x=len;x<stellen;x++)
        {
            erg = "0" + erg;
        }
        return erg;
    }
    public static void resetList1()
    {
        SQLiteDatabase db = helper.getWritableDatabase();
        db.delete("list1",null,null);
        db.close();
    }
    public static void resetList2()
    {
        SQLiteDatabase db = helper.getWritableDatabase();
        db.delete("list2",null,null);
        db.close();
    }
    public static ArrayList<String> getList1()
    {
        barcodeList1 = new ArrayList<String>();
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select id,barcode from list1 order by barcode";
        Cursor cursor = db.rawQuery(sql,null);
        while(cursor.moveToNext())
        {
            long id = cursor.getLong(0);
            String barcode = cursor.getString(1);
            barcodeList1.add(barcode);
        }
        db.close();
        return barcodeList1;
    }
    public static ArrayList<String> getList2()
    {
        barcodeList2 = new ArrayList<String>();
        SQLiteDatabase db = helper.getReadableDatabase();
        String sql = "select id,barcode from list2 order by barcode";
        Cursor cursor = db.rawQuery(sql,null);
        while(cursor.moveToNext())
        {
            long id = cursor.getLong(0);
            String barcode = cursor.getString(1);
            barcodeList2.add(barcode);
        }
        db.close();
        return barcodeList2;
    }
    public static void addToList1(ArrayList<String> barcodeList)
    {
        SQLiteDatabase db = helper.getWritableDatabase();
        for (int i=0;i<barcodeList.size();i++)
        {
            String code = barcodeList.get(i).trim();
            boolean bereitsInList = false;
            if (code.length() == 0) bereitsInList = true;
            if (!bereitsInList)
            {
                ContentValues values = new ContentValues();
                values.put("id",new Date().getTime());
                values.put("barcode",code);
                db.insert("list1",null,values);
            }
        }
        db.close();
    }
    public static void addToList2(ArrayList<String> barcodeList)
    {
        SQLiteDatabase db = helper.getWritableDatabase();
        for (int i=0;i<barcodeList.size();i++)
        {
            String code = barcodeList.get(i).trim();
            boolean bereitsInList = false;
            if (code.length() == 0) bereitsInList = true;
            if (!bereitsInList)
            {
                ContentValues values = new ContentValues();
                values.put("id",new Date().getTime());
                values.put("barcode",code);
                db.insert("list2",null,values);
            }
        }
        db.close();
    }
    public static String serialize(ArrayList<String> al)
    {
        String erg = "";
        for (int i=0;i<al.size();i++)
        {
            if (i<al.size()-1) {
                erg += al.get(i) + "#";
            }
            else
            {
                erg += al.get(i);
            }
        }
        return erg;
    }
    public static ArrayList<String> deserialize(String s)
    {
        ArrayList<String> erg = new ArrayList<String>();
        String[] codes = s.split("#");
        for (int i=0;i<codes.length;i++)
        {
            String code = codes[i].trim();
            if (code.length() > 0) {
                erg.add(code);
            }
        }
        return erg;
    }
    public static ArrayList<String> fromList1NotInList2()
    {
        barcodeList1 = getList1();
        barcodeList2 = getList2();
        ArrayList<String> erg = new ArrayList<String>();
        ArrayList<String> copy = new ArrayList<String>();
        for (int i=0;i<barcodeList2.size();i++)
        {
            copy.add(barcodeList2.get(i));
        }
        for (int i=0;i<barcodeList1.size();i++) {
            int positionGefunden = -1;
            String test = barcodeList1.get(i);
            for (int j = 0; j < copy.size(); j++) {
                String code = copy.get(j);
                if (test.equals(code)) {
                    positionGefunden = j;
                }
            }
            if (positionGefunden == -1) {
                erg.add(test);
            } else {
                ArrayList<String> temp = new ArrayList<String>();
                for (int j = 0; j < copy.size(); j++) {
                    if (j != positionGefunden) temp.add(copy.get(j));
                }
                copy = temp;
            }
        }
        return erg;
    }
    public static ArrayList<String> fromList2NotInList1()
    {
        barcodeList1 = getList1();
        barcodeList2 = getList2();
        ArrayList<String> erg = new ArrayList<String>();
        ArrayList<String> copy = new ArrayList<String>();
        for (int i=0;i<barcodeList1.size();i++)
        {
            copy.add(barcodeList1.get(i));
        }
        for (int i=0;i<barcodeList2.size();i++) {
            int positionGefunden = -1;
            String test = barcodeList2.get(i);
            for (int j = 0; j < copy.size(); j++) {
                String code = copy.get(j);
                if (test.equals(code)) {
                    positionGefunden = j;
                }
            }
            if (positionGefunden == -1) {
                erg.add(test);
            } else {
                ArrayList<String> temp = new ArrayList<String>();
                for (int j = 0; j < copy.size(); j++) {
                    if (j != positionGefunden) temp.add(copy.get(j));
                }
                copy = temp;
            }
        }
        return erg;
    }
    public static void dropFromList1(ArrayList<String> al)
    {
        SQLiteDatabase db = helper.getWritableDatabase();
        for (int i=0;i<al.size();i++)
        {
            String test = al.get(i).trim();
            long xid = -1;
            String sql = "select id from list1 where barcode = ?";
            Cursor cursor = db.rawQuery(sql,new String[]{test});
            while(cursor.moveToNext())
            {
                long id = cursor.getLong(0);
                xid = id;
            }
            if (xid != -1)
            {
                db.delete("list1","id=?",new String[]{""+xid});
            }
        }
        db.close();
    }
    public static void dropFromList2(ArrayList<String> al)
    {
        SQLiteDatabase db = helper.getWritableDatabase();
        for (int i=0;i<al.size();i++)
        {
            String test = al.get(i).trim();
            long xid = -1;
            String sql = "select id from list2 where barcode = ?";
            Cursor cursor = db.rawQuery(sql,new String[]{test});
            while(cursor.moveToNext())
            {
                long id = cursor.getLong(0);
                xid = id;
            }
            if (xid != -1)
            {
                db.delete("list2","id=?",new String[]{""+xid});
            }
        }
        db.close();
    }
}
