/*
 * Decompiled with CFR 0.152.
 */
package eu.myoggradio.barcodescannercompare;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.video.Recorder;
import androidx.camera.video.VideoCapture;
import androidx.camera.video.VideoOutput;
import androidx.camera.view.PreviewView;
import androidx.lifecycle.LifecycleOwner;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import eu.myoggradio.barcodescannercompare.BarcodeUtil;
import eu.myoggradio.barcodescannercompare.L;
import eu.myoggradio.barcodescannercompare.MenuActivity;
import eu.myoggradio.barcodescannercompare.R;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class MainActivity
extends AppCompatActivity
implements View.OnClickListener {
    private PreviewView surface = null;
    private Button scan = null;
    private ListenableFuture<ProcessCameraProvider> provider = null;
    private ImageCapture imageCapture = null;
    private VideoCapture videoCapture = null;
    private ProcessCameraProvider cameraProvider = null;
    private Context context = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this.getBaseContext();
        this.setContentView(R.layout.activity_main);
        this.scan = (Button)this.findViewById(R.id.scan);
        this.surface = (PreviewView)this.findViewById(R.id.camera_view);
        this.surface.setOnClickListener((View.OnClickListener)this);
        try {
            this.provider = ProcessCameraProvider.getInstance((Context)this);
            this.provider.addListener(() -> {
                try {
                    ProcessCameraProvider cameraProvider;
                    this.cameraProvider = cameraProvider = (ProcessCameraProvider)this.provider.get();
                    this.startCameraX(cameraProvider);
                }
                catch (Exception e) {
                    L.e("MainActivity:onCreate:Exception:");
                    L.e(e.toString());
                }
            }, this.getExecutor());
        }
        catch (Exception e) {
            L.e("MainActivity:onCreate:Exception:");
            L.e(e.toString());
        }
        this.scan.setOnClickListener((View.OnClickListener)this);
    }

    private void startCameraX(ProcessCameraProvider cameraProvider) {
        try {
            cameraProvider.unbindAll();
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
            Preview preview = new Preview.Builder().build();
            preview.setSurfaceProvider(this.surface.getSurfaceProvider());
            this.imageCapture = new ImageCapture.Builder().setCaptureMode(1).build();
            Recorder recorder = new Recorder.Builder().build();
            this.videoCapture = new VideoCapture.Builder((VideoOutput)recorder).build();
            cameraProvider.bindToLifecycle((LifecycleOwner)this, cameraSelector, new UseCase[]{preview, this.imageCapture, this.videoCapture});
        }
        catch (Exception e) {
            L.e("MainActivity:startCamera:Exception:");
            L.e(e.toString());
        }
    }

    private Executor getExecutor() {
        return this.getMainExecutor();
    }

    public void onClick(View v) {
        if (v == this.scan) {
            // empty if block
        }
        if (v == this.surface) {
            L.d("MainActivity:onClick:surface");
            final File file = new File(Environment.getExternalStorageDirectory().toString(), "/Download/barcodescannercompare.png");
            ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(file).build();
            this.imageCapture.takePicture(outputFileOptions, this.getExecutor(), new ImageCapture.OnImageSavedCallback(){

                public void onImageSaved(ImageCapture.OutputFileResults outputFileResults) {
                    L.d("MainActivity:onClick:surface:Image saved");
                    try {
                        MainActivity.this.cameraProvider.unbindAll();
                        InputImage image = InputImage.fromFilePath((Context)MainActivity.this.context, (Uri)Uri.fromFile((File)file));
                        BarcodeScanner scanner = BarcodeScanning.getClient();
                        scanner.process(image).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<Barcode>>(){

                            public void onSuccess(List<Barcode> barcodes) {
                                ArrayList<String> codes = new ArrayList<String>();
                                for (Barcode barcode : barcodes) {
                                    String rawValue = barcode.getRawValue();
                                    codes.add(rawValue);
                                    L.d("MainActivity:onClick:surface:rawValue:" + rawValue);
                                }
                                L.d("MainActivity:onClick:surface:Anzahl Barcodes:" + codes.size());
                                if (codes.size() == 0) {
                                    MainActivity.this.startCameraX(MainActivity.this.cameraProvider);
                                } else {
                                    try {
                                        String serial = BarcodeUtil.serialize(codes);
                                        Intent menuIntent = new Intent(MainActivity.this.context, MenuActivity.class);
                                        menuIntent.putExtra("barcodes", serial);
                                        MainActivity.this.startActivity(menuIntent);
                                        MainActivity.this.finish();
                                    }
                                    catch (Exception e) {
                                        L.e("MainActivity:onClick:surface:onImageSaved:Exception:");
                                        L.e(e.toString());
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        L.e("MainActivity:onClick:surface:Exception:");
                        L.e(e.toString());
                    }
                }

                public void onError(ImageCaptureException error) {
                    L.e("MainActivity:onClick:surface:Error:");
                    L.e(error.toString());
                }
            });
        }
    }
}

